"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yAxisFormatter = exports.useDateFormatter = exports.tooltipProps = exports.getDomain = exports.TIME_LABELS = exports.NoDataState = exports.NUM_BUCKETS = exports.LoadingState = exports.ErrorState = exports.EmptyContainer = exports.ChartContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _number = require("../../../../common/formatters/number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/common/criterion_preview_chart/criterion_preview_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tooltipProps = exports.tooltipProps = {
  headerFormatter: ({
    value
  }) => (0, _moment.default)(value).format('Y-MM-DD HH:mm:ss')
};
const NUM_BUCKETS = exports.NUM_BUCKETS = 20;
const TIME_LABELS = exports.TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.infra.alerts.timeLabels.days', {
    defaultMessage: 'days'
  })
};
const useDateFormatter = (xMin, xMax) => {
  const dateFormatter = (0, _react.useMemo)(() => {
    if (typeof xMin === 'number' && typeof xMax === 'number') {
      return (0, _charts.niceTimeFormatter)([xMin, xMax]);
    } else {
      return value => `${value}`;
    }
  }, [xMin, xMax]);
  return dateFormatter;
};
exports.useDateFormatter = useDateFormatter;
const yAxisFormatter = exports.yAxisFormatter = _number.formatNumber;
const getDomain = (series, stacked = false) => {
  let min = null;
  let max = null;
  const valuesByTimestamp = series.reduce((acc, serie) => {
    serie.points.forEach(point => {
      const valuesForTimestamp = acc[point.timestamp] || [];
      acc[point.timestamp] = [...valuesForTimestamp, point.value];
    });
    return acc;
  }, {});
  const pointValues = Object.values(valuesByTimestamp);
  pointValues.forEach(results => {
    const maxResult = stacked ? (0, _lodash.sum)(results) : (0, _lodash.max)(results);
    const minResult = (0, _lodash.min)(results);
    if (maxResult && (!max || maxResult > max)) {
      max = maxResult;
    }
    if (minResult && (!min || minResult < min)) {
      min = minResult;
    }
  });
  const timestampValues = Object.keys(valuesByTimestamp).map(Number);
  const minTimestamp = (0, _lodash.min)(timestampValues) || 0;
  const maxTimestamp = (0, _lodash.max)(timestampValues) || 0;
  return {
    yMin: min || 0,
    yMax: max || 0,
    xMin: minTimestamp,
    xMax: maxTimestamp
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 3
  }
}, children);
exports.EmptyContainer = EmptyContainer;
const ChartContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 3
  }
}, children);
exports.ChartContainer = ChartContainer;
const NoDataState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "noChartData",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.alerts.charts.noDataMessage",
    defaultMessage: "No chart data available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
};
exports.NoDataState = NoDataState;
const LoadingState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "loadingData",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })));
};
exports.LoadingState = LoadingState;
const ErrorState = () => {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "chartErrorState",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.alerts.charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })));
};
exports.ErrorState = ErrorState;