"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withActiveInferenceSpan = void 0;
var _sdk = require("@elastic/opentelemetry-node/sdk");
var _tracingUtils = require("@kbn/tracing-utils");
var _api = require("@opentelemetry/api");
var _create_inference_context = require("./create_inference_context");
var _root_inference_span = require("./root_inference_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates an active "inference"-scoped span, that is, every span created in this
 * context will be exported via the inference exporters. This allows us to export
 * a subset of spans to external systems like Phoenix.
 */

const TRACER = _api.trace.getTracer('inference');
const withActiveInferenceSpan = exports.withActiveInferenceSpan = (0, _tracingUtils.createWithActiveSpan)({
  tracer: TRACER
}, (name, opts, ctx, cb) => {
  if (_sdk.core.isTracingSuppressed(ctx)) {
    return cb();
  }
  const {
    context: parentContext,
    isRoot
  } = (0, _create_inference_context.createInferenceContext)();
  return (0, _tracingUtils.withActiveSpan)(name, {
    ...opts,
    attributes: {
      ...opts.attributes,
      [_root_inference_span.IS_ROOT_INFERENCE_SPAN_ATTRIBUTE_NAME]: isRoot
    }
  }, parentContext, span => {
    return cb(span);
  });
});