"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPE_DEFINITION = exports.SUB_TYPE_MAP_TO_MAIN = exports.MAIN_TYPES = exports.MAIN_DATA_TYPE_DEFINITION = exports.ALL_DATA_TYPES = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/constants/data_types_definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TYPE_DEFINITION = exports.TYPE_DEFINITION = {
  text: {
    value: 'text',
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.textDescription', {
      defaultMessage: 'Text'
    }),
    documentation: {
      main: 'text'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.textLongDescription",
      defaultMessage: "Text fields support full-text search by breaking strings into individual, searchable terms. To index structured content, such as an email address, use the {keyword}.",
      values: {
        keyword: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('keyword'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 32,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.textLongDescription.keywordTypeLink', {
          defaultMessage: 'keyword data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }))
  },
  match_only_text: {
    value: 'match_only_text',
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.matchOnlyTextDescription', {
      defaultMessage: 'Match only text'
    }),
    documentation: {
      main: 'match-only-text'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.matchOnlyTextLongDescription",
      defaultMessage: "A variant of {text} that trades scoring and efficiency of positional queries for space efficiency. This field effectively stores data the same way as a text field that only indexes documents (index_options: docs) and disables norms (norms: false). Term queries perform as fast if not faster as on text fields, however queries that need positions such as the match_phrase query perform slower as they need to look at the _source document to verify whether a phrase matches. All queries return constant scores that are equal to 1.0.",
      values: {
        text: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('text'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.matchOnlyTextLongDescription.textTypeLink', {
          defaultMessage: 'text'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }))
  },
  keyword: {
    value: 'keyword',
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.keywordDescription', {
      defaultMessage: 'Keyword'
    }),
    documentation: {
      main: 'keyword#keyword-field-type'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.keywordLongDescription",
      defaultMessage: "Keyword fields support searching for an exact value and are useful for filtering, sorting, and aggregations. To index full-text content, such as an email body, use the {textType}.",
      values: {
        textType: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('text'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.keywordLongDescription.textTypeLink', {
          defaultMessage: 'text data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }))
  },
  constant_keyword: {
    value: 'constant_keyword',
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.constantKeywordDescription', {
      defaultMessage: 'Constant keyword'
    }),
    documentation: {
      main: 'keyword#constant-keyword-field-type'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.constantKeywordLongDescription",
      defaultMessage: "Constant keyword fields are a special type of keyword fields for fields that contain the same keyword across all documents in the index. Supports the same queries and aggregations as {keyword} fields.",
      values: {
        keyword: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 22
          }
        }, 'keyword')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }))
  },
  numeric: {
    value: 'numeric',
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.numericDescription', {
      defaultMessage: 'Numeric'
    }),
    documentation: {
      main: 'number'
    },
    subTypes: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.numericSubtypeDescription', {
        defaultMessage: 'Numeric type'
      }),
      types: ['byte', 'double', 'float', 'half_float', 'integer', 'long', 'scaled_float', 'short', 'unsigned_long']
    }
  },
  byte: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.byteDescription', {
      defaultMessage: 'Byte'
    }),
    value: 'byte',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.byteLongDescription",
      defaultMessage: "Byte fields accept a signed 8-bit integer with a minimum value of {minValue} and a maximum value of {maxValue}.",
      values: {
        minValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 23
          }
        }, "-128"),
        maxValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 161,
            columnNumber: 23
          }
        }, "127")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }))
  },
  double: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.doubleDescription', {
      defaultMessage: 'Double'
    }),
    value: 'double',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.doubleLongDescription",
      defaultMessage: "Double fields accept a double-precision 64-bit floating point number, restricted to finite values (IEEE 754).",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }))
  },
  integer: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.integerDescription', {
      defaultMessage: 'Integer'
    }),
    value: 'integer',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.integerLongDescription",
      defaultMessage: "Integer fields accept a signed 32-bit integer with a minimum value of {minValue} and a maximum value of {maxValue}.",
      values: {
        minValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 15
          }
        }, "-2", /*#__PURE__*/_react.default.createElement("sup", {
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 19
          }
        }, "31")),
        maxValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 198,
            columnNumber: 15
          }
        }, "2", /*#__PURE__*/_react.default.createElement("sup", {
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 199,
            columnNumber: 18
          }
        }, "31"), "-1")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }))
  },
  unsigned_long: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.unsignedLongDescription', {
      defaultMessage: 'Unsigned long'
    }),
    value: 'unsigned_long',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.unsignedLongLongDescription",
      defaultMessage: "Unsigned long fields accept an unsigned 64-bit integer with a minimum value of {minValue} and a maximum value of {maxValue}.",
      values: {
        minValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 23
          }
        }, "0"),
        maxValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 15
          }
        }, "2", /*#__PURE__*/_react.default.createElement("sup", {
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 221,
            columnNumber: 18
          }
        }, "64"), "-1")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 9
      }
    }))
  },
  long: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.longDescription', {
      defaultMessage: 'Long'
    }),
    value: 'long',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.longLongDescription",
      defaultMessage: "Long fields accept a signed 64-bit integer with a minimum value of {minValue} and a maximum value of {maxValue}.",
      values: {
        minValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 241,
            columnNumber: 15
          }
        }, "-2", /*#__PURE__*/_react.default.createElement("sup", {
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 242,
            columnNumber: 19
          }
        }, "63")),
        maxValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 15
          }
        }, "2", /*#__PURE__*/_react.default.createElement("sup", {
          className: "eui-alignTop",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 247,
            columnNumber: 18
          }
        }, "63"), "-1")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }))
  },
  float: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.floatDescription', {
      defaultMessage: 'Float'
    }),
    value: 'float',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.floatLongDescription",
      defaultMessage: "Float fields accept a single-precision 32-bit floating point number, restricted to finite values (IEEE 754).",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    }))
  },
  half_float: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.halfFloatDescription', {
      defaultMessage: 'Half float'
    }),
    value: 'half_float',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.halfFloatLongDescription",
      defaultMessage: "Half-float fields accept a half-precision 16-bit floating point number, restricted to finite values (IEEE 754).",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 9
      }
    }))
  },
  scaled_float: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.scaledFloatDescription', {
      defaultMessage: 'Scaled float'
    }),
    value: 'scaled_float',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.scaledFloatLongDescription",
      defaultMessage: "Scaled-float fields accept a floating point number that is backed by a {longType} and scaled by a fixed {doubleType} scaling factor. Use this data type to store floating point data into an integer using a scaling factor. This saves disk space, but affects accuracy.",
      values: {
        longType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 294,
            columnNumber: 23
          }
        }, "long"),
        doubleType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 25
          }
        }, "double")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 9
      }
    }))
  },
  short: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.shortDescription', {
      defaultMessage: 'Short'
    }),
    value: 'short',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.shortLongDescription",
      defaultMessage: "Short fields accept a signed 16-bit integer with a minimum value of {minValue} and a maximum value of {maxValue}.",
      values: {
        minValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 312,
            columnNumber: 23
          }
        }, "-32,768"),
        maxValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 313,
            columnNumber: 23
          }
        }, "32,767")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 9
      }
    }))
  },
  date: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.dateDescription', {
      defaultMessage: 'Date'
    }),
    value: 'date',
    documentation: {
      main: 'date'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.dateLongDescription",
      defaultMessage: "Date fields accept strings with formatted dates (\"2015/01/01 12:10:30\"), long numbers representing milliseconds since the epoch, and integers representing seconds since the epoch. Multiple date formats are allowed. Dates with timezones are converted to UTC.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 9
      }
    }))
  },
  date_nanos: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.dateNanosDescription', {
      defaultMessage: 'Date nanoseconds'
    }),
    value: 'date_nanos',
    documentation: {
      main: 'date_nanos'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.dateNanosLongDescription",
      defaultMessage: "Date nanoseconds fields store dates in nanosecond resolution. Aggregations remain in millisecond resolution. To store dates in millisecond resolution, use the {date}.",
      values: {
        date: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('date'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 351,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.dateNanosLongDescription.dateTypeLink', {
          defaultMessage: 'date data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 9
      }
    }))
  },
  binary: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.binaryDescription', {
      defaultMessage: 'Binary'
    }),
    value: 'binary',
    documentation: {
      main: 'binary'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.binaryLongDescription",
      defaultMessage: "Binary fields accept a binary value as a Base64-encoded string. By default, binary fields are not stored or searchable.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 9
      }
    }))
  },
  ip: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.ipDescription', {
      defaultMessage: 'IP'
    }),
    value: 'ip',
    documentation: {
      main: 'ip'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.ipLongDescription",
      defaultMessage: "IP fields accept IPv4 or IPv6 addresses. If you need to store IP ranges in a single field, use the {ipRange}.",
      values: {
        ipRange: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('range'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 397,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.ipLongDescription.ipRangeTypeLink', {
          defaultMessage: 'IP range data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 9
      }
    }))
  },
  boolean: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.booleanDescription', {
      defaultMessage: 'Boolean'
    }),
    value: 'boolean',
    documentation: {
      main: 'boolean'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.booleanLongDescription",
      defaultMessage: "Boolean fields accept JSON {true} and {false} values, as well as strings which are interpreted as true or false.",
      values: {
        true: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 425,
            columnNumber: 19
          }
        }, "true"),
        false: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 426,
            columnNumber: 20
          }
        }, "false")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 9
      }
    }))
  },
  range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rangeDescription', {
      defaultMessage: 'Range'
    }),
    value: 'range',
    documentation: {
      main: 'range'
    },
    subTypes: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rangeSubtypeDescription', {
        defaultMessage: 'Range type'
      }),
      types: ['date_range', 'double_range', 'float_range', 'integer_range', 'ip_range', 'long_range']
    }
  },
  object: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.objectDescription', {
      defaultMessage: 'Object'
    }),
    value: 'object',
    documentation: {
      main: 'object'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 463,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.objectLongDescription",
      defaultMessage: "Object fields can contain children, which are queried as a flattened list. To query child objects independently, use the {nested}.",
      values: {
        nested: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('nested'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 469,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.objectLongDescription.nestedTypeLink', {
          defaultMessage: 'nested data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 464,
        columnNumber: 9
      }
    }))
  },
  nested: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.nestedDescription', {
      defaultMessage: 'Nested'
    }),
    value: 'nested',
    documentation: {
      main: 'nested'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 492,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.nestedLongDescription",
      defaultMessage: "Like {objects}, nested fields can contain children. The difference is that you can query their child objects independently.",
      values: {
        objects: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('object'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 498,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.nestedLongDescription.objectTypeLink', {
          defaultMessage: 'objects'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 493,
        columnNumber: 9
      }
    }))
  },
  rank_feature: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rankFeatureDescription', {
      defaultMessage: 'Rank feature'
    }),
    value: 'rank_feature',
    documentation: {
      main: 'rank-feature'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 521,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.rankFeatureLongDescription",
      defaultMessage: "The rank feature field accepts a number that will boost documents in {rankFeatureQuery}.",
      values: {
        rankFeatureQuery: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getRankFeatureQueryLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 527,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rankFeatureLongDescription.queryLink', {
          defaultMessage: 'rank_feature queries'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 522,
        columnNumber: 9
      }
    }))
  },
  rank_features: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rankFeaturesDescription', {
      defaultMessage: 'Rank features'
    }),
    value: 'rank_features',
    documentation: {
      main: 'rank-features'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 550,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.rankFeaturesLongDescription",
      defaultMessage: "The rank features field accepts numeric vectors that will boost documents in {rankFeatureQuery}.",
      values: {
        rankFeatureQuery: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getRankFeatureQueryLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 556,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.rankFeaturesLongDescription.queryLink', {
          defaultMessage: 'rank_feature queries'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 551,
        columnNumber: 9
      }
    }))
  },
  passthrough: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.passthroughDescription', {
      defaultMessage: 'Passthrough'
    }),
    value: 'passthrough',
    documentation: {
      main: 'passthrough'
    }
  },
  dense_vector: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.denseVectorDescription', {
      defaultMessage: 'Dense vector'
    }),
    value: 'dense_vector',
    documentation: {
      main: 'dense-vector'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 588,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.denseVectorLongDescription",
      defaultMessage: "Dense vector fields store vectors of float values, useful for document scoring.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 589,
        columnNumber: 9
      }
    }))
  },
  date_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.dateRangeDescription', {
      defaultMessage: 'Date range'
    }),
    value: 'date_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 602,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.dateRangeLongDescription",
      defaultMessage: "Date range fields accept an unsigned 64-bit integer representing milliseconds since the system epoch.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 603,
        columnNumber: 9
      }
    }))
  },
  double_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.doubleRangeDescription', {
      defaultMessage: 'Double range'
    }),
    value: 'double_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 616,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.doubleRangeLongDescription",
      defaultMessage: "Double range fields accept a 64-bit double precision floating point number (IEEE 754 binary64).",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 617,
        columnNumber: 9
      }
    }))
  },
  float_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.floatRangeDescription', {
      defaultMessage: 'Float range'
    }),
    value: 'float_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 630,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.floatRangeLongDescription",
      defaultMessage: "Float range fields accept a 32-bit single precision floating point number (IEEE 754 binary32).",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 631,
        columnNumber: 9
      }
    }))
  },
  integer_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.integerRangeDescription', {
      defaultMessage: 'Integer range'
    }),
    value: 'integer_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 644,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.integerRangeLongDescription",
      defaultMessage: "Integer range fields accept a signed 32-bit integer.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 645,
        columnNumber: 9
      }
    }))
  },
  long_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.longRangeDescription', {
      defaultMessage: 'Long range'
    }),
    value: 'long_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 658,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.longRangeLongDescription",
      defaultMessage: "Long range fields accept a signed 64-bit integer.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 659,
        columnNumber: 9
      }
    }))
  },
  ip_range: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.ipRangeDescription', {
      defaultMessage: 'IP range'
    }),
    value: 'ip_range',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 672,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.ipRangeLongDescription",
      defaultMessage: "IP range fields accept an IPv4 or IPV6 address.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 673,
        columnNumber: 9
      }
    }))
  },
  geo_point: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.geoPointDescription', {
      defaultMessage: 'Geo-point'
    }),
    value: 'geo_point',
    documentation: {
      main: 'geo-point'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 689,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.geoPointLongDescription",
      defaultMessage: "Geo-point fields accept latitude and longitude pairs. Use this data type to search within a bounding box, aggregate documents geographically, and sort documents by distance.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 690,
        columnNumber: 9
      }
    }))
  },
  geo_shape: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.geoShapeDescription', {
      defaultMessage: 'Geo-shape'
    }),
    value: 'geo_shape',
    documentation: {
      main: 'geo-shape',
      learnMore: 'geo-shape#geoshape-indexing-approach'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 707,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.geoShapeType.fieldDescription",
      defaultMessage: "Geo-shapes are indexed by decomposing the shape into a triangular mesh and indexing each triangle as a 7-dimensional point in a BKD tree. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('geo_shape', 'learnMore'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 713,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.geoShapeType.fieldDescription.learnMoreLink', {
          defaultMessage: 'Learn more.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 708,
        columnNumber: 9
      }
    }))
  },
  completion: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.completionSuggesterDescription', {
      defaultMessage: 'Completion suggester'
    }),
    value: 'completion',
    documentation: {
      main: 'completion'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 739,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.completionSuggesterLongDescription",
      defaultMessage: "Completion suggester fields support autocomplete, but require special data structures that occupy memory and build slowly.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 740,
        columnNumber: 9
      }
    }))
  },
  token_count: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.tokenCountDescription', {
      defaultMessage: 'Token count'
    }),
    value: 'token_count',
    documentation: {
      main: 'token-count'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 756,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.tokenCountLongDescription",
      defaultMessage: "Token count fields accept string values.  These values are analyzed, and the number of tokens in the string are indexed.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 757,
        columnNumber: 9
      }
    }))
  },
  percolator: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.percolatorDescription', {
      defaultMessage: 'Percolator'
    }),
    value: 'percolator',
    documentation: {
      main: 'percolator'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 773,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.percolatorLongDescription",
      defaultMessage: "The percolator data type enables {percolator}.",
      values: {
        percolator: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getPercolatorQueryLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 779,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.percolatorLongDescription.learnMoreLink', {
          defaultMessage: 'percolator queries'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 774,
        columnNumber: 9
      }
    }))
  },
  histogram: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.histogramDescription', {
      defaultMessage: 'Histogram'
    }),
    value: 'histogram',
    documentation: {
      main: 'histogram'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 802,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.histogramLongDescription",
      defaultMessage: "Histogram fields store pre-aggregated numerical data representing a histogram, and are intended for use with aggregations.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 803,
        columnNumber: 9
      }
    }))
  },
  join: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.joinDescription', {
      defaultMessage: 'Join'
    }),
    value: 'join',
    documentation: {
      main: 'parent-join'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 819,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.joinLongDescription",
      defaultMessage: "Join fields define parent-child relationships among documents of the same index.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 820,
        columnNumber: 9
      }
    }))
  },
  alias: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.aliasDescription', {
      defaultMessage: 'Alias'
    }),
    value: 'alias',
    documentation: {
      main: 'field-alias'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 836,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.aliasLongDescription",
      defaultMessage: "Alias fields accept an alternative name for a field, which you can use in search requests.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 837,
        columnNumber: 9
      }
    }))
  },
  search_as_you_type: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.searchAsYouTypeDescription', {
      defaultMessage: 'Search-as-you-type'
    }),
    value: 'search_as_you_type',
    documentation: {
      main: 'search-as-you-type'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 853,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.searchAsYouTypeLongDescription",
      defaultMessage: "Search-as-you-type fields break strings into subfields for search suggestions, and will match terms at any position in the string.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 854,
        columnNumber: 9
      }
    }))
  },
  flattened: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.flattenedDescription', {
      defaultMessage: 'Flattened'
    }),
    value: 'flattened',
    documentation: {
      main: 'flattened'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 870,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.flattenedLongDescription",
      defaultMessage: "Flattened fields map an object as a single field and are useful for indexing objects with a large or unknown number of unique keys. Flattened fields support basic queries only.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 871,
        columnNumber: 9
      }
    }))
  },
  shape: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.shapeDescription', {
      defaultMessage: 'Shape'
    }),
    value: 'shape',
    documentation: {
      main: 'shape'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 887,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.shapeLongDescription",
      defaultMessage: "Shape fields enable searching of complex shapes, such as rectangles and polygons.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 888,
        columnNumber: 9
      }
    }))
  },
  sparse_vector: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.sparseVectorDescription', {
      defaultMessage: 'Sparse vector'
    }),
    value: 'sparse_vector',
    documentation: {
      main: 'sparse-vector'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 904,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.sparseVectorLongDescription",
      defaultMessage: "Sparse vector fields index features and weights, useful for document scoring.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 905,
        columnNumber: 9
      }
    }))
  },
  semantic_text: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.semanticTextDescription', {
      defaultMessage: 'Semantic text'
    }),
    value: 'semantic_text',
    documentation: {
      main: 'semantic-text'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 921,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.semanticTextLongDescription",
      defaultMessage: "Semantic text fields enable semantic search using text embeddings.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 922,
        columnNumber: 9
      }
    }))
  },
  point: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.pointDescription', {
      defaultMessage: 'Point'
    }),
    value: 'point',
    documentation: {
      main: 'point'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 938,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.pointLongDescription",
      defaultMessage: "Point fields enable searching of {code} pairs that fall in a 2-dimensional planar coordinate system.",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 943,
            columnNumber: 19
          }
        }, 'x,y')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 939,
        columnNumber: 9
      }
    }))
  },
  version: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.versionDescription', {
      defaultMessage: 'Version'
    }),
    value: 'version',
    documentation: {
      main: 'version'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 958,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.versionLongDescription",
      defaultMessage: "Version fields are helpful to handle software version values. This field isn\u2019t optimized for heavy wildcard, regex, or fuzzy searches. For these query types, use the {keywordType}.",
      values: {
        keywordType: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getTypeDocLink('keyword'),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 964,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.versionLongDescription.keywordTypeLink', {
          defaultMessage: 'keyword data type'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 959,
        columnNumber: 9
      }
    }))
  },
  wildcard: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.wildcardDescription', {
      defaultMessage: 'Wildcard'
    }),
    value: 'wildcard',
    documentation: {
      main: 'keyword#wildcard-field-type'
    },
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 987,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.wildcardLongDescription",
      defaultMessage: "Wildcard fields store values optimized for wildcard grep-like queries.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 988,
        columnNumber: 9
      }
    }))
  },
  other: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dataType.otherDescription', {
      defaultMessage: 'Other'
    }),
    value: 'other',
    description: () => /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1001,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.dataType.otherLongDescription",
      defaultMessage: "Specify type parameters in JSON.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1002,
        columnNumber: 9
      }
    }))
  }
};
const MAIN_TYPES = exports.MAIN_TYPES = ['alias', 'binary', 'boolean', 'completion', 'constant_keyword', 'date', 'date_nanos', 'dense_vector', 'flattened', 'geo_point', 'geo_shape', 'histogram', 'ip', 'join', 'keyword', 'match_only_text', 'nested', 'numeric', 'object', 'other', 'percolator', 'point', 'range', 'rank_feature', 'rank_features', 'search_as_you_type', 'semantic_text', 'shape', 'sparse_vector', 'text', 'token_count', 'version', 'wildcard'];
const MAIN_DATA_TYPE_DEFINITION = exports.MAIN_DATA_TYPE_DEFINITION = MAIN_TYPES.reduce((acc, type) => ({
  ...acc,
  [type]: TYPE_DEFINITION[type]
}), {});

/**
 * Return a map of subType -> mainType
 *
 * @example
 *
 * {
 *   long: 'numeric',
 *   integer: 'numeric',
 *   short: 'numeric',
 * }
 */
const SUB_TYPE_MAP_TO_MAIN = exports.SUB_TYPE_MAP_TO_MAIN = Object.entries(MAIN_DATA_TYPE_DEFINITION).reduce((acc, [type, definition]) => {
  if ({}.hasOwnProperty.call(definition, 'subTypes')) {
    definition.subTypes.types.forEach(subType => {
      acc[subType] = type;
    });
  }
  return acc;
}, {});

// Single source of truth of all the possible data types.
const ALL_DATA_TYPES = exports.ALL_DATA_TYPES = [...Object.keys(MAIN_DATA_TYPE_DEFINITION), ...Object.keys(SUB_TYPE_MAP_TO_MAIN)];