"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configurationFormSchema = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../services/documentation");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/configuration_form/configuration_form_schema.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  isJsonField
} = _shared_imports.fieldValidators;
const fieldPathComboBoxConfig = {
  helpText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.sourceFieldPathComboBoxHelpText', {
    defaultMessage: 'Accepts a path to the field, including wildcards.'
  }),
  type: _shared_imports.FIELD_TYPES.COMBO_BOX,
  defaultValue: [],
  serializer: options => options.map(({
    label
  }) => label),
  deserializer: values => values.map(value => ({
    label: value
  }))
};
const configurationFormSchema = exports.configurationFormSchema = {
  metaField: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.metaFieldEditorLabel', {
      defaultMessage: '_meta field data'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.configuration.metaFieldEditorHelpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 17
          }
        }, JSON.stringify({
          arbitrary_data: 'anything_goes'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }),
    validations: [{
      validator: isJsonField(_i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.metaFieldEditorJsonError', {
        defaultMessage: 'The _meta field JSON is not valid.'
      }), {
        allowEmptyString: true
      })
    }],
    deserializer: value => {
      if (value === '') {
        return value;
      }
      return JSON.stringify(value, null, 2);
    },
    serializer: value => {
      try {
        const parsed = JSON.parse(value);
        // If an empty object was passed, strip out this value entirely.
        if (!Object.keys(parsed).length) {
          return undefined;
        }
        return parsed;
      } catch (error) {
        // swallow error and return non-parsed value;
        return value;
      }
    }
  },
  sourceField: {
    option: {
      type: _shared_imports.FIELD_TYPES.SUPER_SELECT,
      defaultValue: 'stored'
    },
    includes: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.includeSourceFieldsLabel', {
        defaultMessage: 'Include fields'
      }),
      ...fieldPathComboBoxConfig
    },
    excludes: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.excludeSourceFieldsLabel', {
        defaultMessage: 'Exclude fields'
      }),
      ...fieldPathComboBoxConfig
    }
  },
  dynamicMapping: {
    enabled: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.enableDynamicMappingsLabel', {
        defaultMessage: 'Enable dynamic mapping'
      }),
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      defaultValue: true
    },
    throwErrorsForUnmappedFields: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.throwErrorsForUnmappedFieldsLabel', {
        defaultMessage: 'Throw an exception when a document contains an unmapped field'
      }),
      helpText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.dynamicMappingStrictHelpText', {
        defaultMessage: 'By default, unmapped fields will be silently ignored when dynamic mapping is disabled. Optionally, you can choose to throw an exception when a document contains an unmapped field.'
      }),
      type: _shared_imports.FIELD_TYPES.CHECKBOX,
      defaultValue: false
    },
    numeric_detection: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.numericFieldLabel', {
        defaultMessage: 'Map numeric strings as numbers'
      }),
      helpText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.numericFieldDescription', {
        defaultMessage: 'For example, "1.0" would be mapped as a float and "1" would be mapped as an integer.'
      }),
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      defaultValue: false
    },
    date_detection: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.dateDetectionFieldLabel', {
        defaultMessage: 'Map date strings as dates'
      }),
      type: _shared_imports.FIELD_TYPES.TOGGLE,
      defaultValue: true
    },
    dynamic_date_formats: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.dynamicDatesFieldLabel', {
        defaultMessage: 'Date formats'
      }),
      helpText: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.mappingsEditor.configuration.dynamicDatesFieldHelpText",
        defaultMessage: "Strings in these formats will be mapped as dates. You can use built-in formats or custom formats. {docsLink}",
        values: {
          docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.documentationService.getDateFormatLink(),
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 155,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.dynamicDatesFieldDocumentionLink', {
            defaultMessage: 'Learn more.'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 9
        }
      }),
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      defaultValue: ['strict_date_optional_time', 'yyyy/MM/dd HH:mm:ss Z||yyyy/MM/dd Z']
    }
  },
  _routing: {
    required: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.routingLabel', {
        defaultMessage: 'Require _routing value for CRUD operations'
      }),
      defaultValue: false
    }
  },
  _size: {
    enabled: {
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.sizeLabel', {
        defaultMessage: 'Index the _source field size in bytes'
      }),
      defaultValue: false
    }
  },
  subobjects: {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.configuration.subobjectsLabel', {
      defaultMessage: 'Allow objects to hold further subobjects'
    }),
    defaultValue: true
  }
};