"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../../../services/breadcrumbs");
var _component_templates_context = require("../../component_templates_context");
var _shared_imports = require("../../shared_imports");
var _component_template_form = require("../component_template_form");
var _redirect_path = require("../../../../hooks/redirect_path");
var _use_step_from_query_string = require("../use_step_from_query_string");
var _use_update_associated_ds_mappings = require("../component_template_ds_mappings/use_update_associated_ds_mappings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_edit/component_template_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComponentTemplateEdit = ({
  match: {
    params: {
      name
    }
  },
  history
}) => {
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    activeStep: defaultActiveStep,
    updateStep
  } = (0, _use_step_from_query_string.useStepFromQueryString)(history);
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const decodedName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    error,
    data: componentTemplate,
    isLoading
  } = api.useLoadComponentTemplate(decodedName);
  const {
    data: dataStreamResponse
  } = api.useLoadComponentTemplatesDatastream(decodedName);
  const dataStreams = (0, _react.useMemo)(() => {
    var _dataStreamResponse$d;
    return (_dataStreamResponse$d = dataStreamResponse === null || dataStreamResponse === void 0 ? void 0 : dataStreamResponse.data_streams) !== null && _dataStreamResponse$d !== void 0 ? _dataStreamResponse$d : [];
  }, [dataStreamResponse]);
  // If the component template is referenced by an index template that is part of
  // a package and is managed we can allow the user to roll it over if possible.
  const {
    data: refIndexTemplate
  } = api.useLoadReferencedIndexTemplateMeta(decodedName);
  const canRollover = (0, _react.useMemo)(() => Boolean((refIndexTemplate === null || refIndexTemplate === void 0 ? void 0 : refIndexTemplate.managed_by) && (refIndexTemplate === null || refIndexTemplate === void 0 ? void 0 : refIndexTemplate.package)), [refIndexTemplate]);
  const {
    updateAssociatedDsMappings
  } = (0, _use_update_associated_ds_mappings.useUpdateAssociatedDsMappings)();
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateEdit);
  }, []);
  const onSave = async updatedComponentTemplate => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error: saveErrorObject
    } = await api.updateComponentTemplate(updatedComponentTemplate);
    setIsSaving(false);
    if (saveErrorObject) {
      setSaveError(saveErrorObject);
      return;
    }

    // Update mappings from template for associated data streams for @custom templates or when
    // the component template is referenced by a managed package index template. Each data stream
    // updates its mappings from its index template. If updating fails, a modal prompts to rollover.
    if (updatedComponentTemplate.name.endsWith('@custom') || canRollover) {
      await updateAssociatedDsMappings(updatedComponentTemplate.name);
    }
    redirectTo({
      pathname: encodeURI(`/component_templates/${encodeURIComponent(updatedComponentTemplate.name)}`)
    });
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.loadingDescription",
      defaultMessage: "Loading component template\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateEdit.loadComponentTemplateError",
        defaultMessage: "Error loading component template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }),
      error: error,
      "data-test-subj": "loadComponentTemplateError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.editPageTitle",
      defaultMessage: "Edit component template ''{name}''",
      values: {
        name: decodedName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    })),
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), (componentTemplate === null || componentTemplate === void 0 ? void 0 : componentTemplate.deprecated) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.deprecatedTemplateWarningTitle",
      defaultMessage: "This component template is deprecated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }),
    iconType: "warning",
    color: "warning",
    "data-test-subj": "deprecatedTemplateCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateEdit.deprecatedTemplateWarningDescription",
    defaultMessage: "This component template is no longer supported and might be removed in a future release. Instead, use one of the other component templates available or create a new one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultValue: componentTemplate,
    dataStreams: dataStreams,
    canRollover: canRollover,
    defaultActiveWizardSection: defaultActiveStep,
    onStepChange: updateStep,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isEditing: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }));
};
exports.ComponentTemplateEdit = ComponentTemplateEdit;