"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateClone = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../shared_imports");
var _component_templates_context = require("../../component_templates_context");
var _component_template_create = require("../component_template_create");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_clone/component_template_clone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComponentTemplateClone = props => {
  const {
    sourceComponentTemplateName
  } = props.match.params;
  const decodedSourceName = (0, _shared_imports.attemptToURIDecode)(sourceComponentTemplateName);
  const {
    toasts,
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    error,
    data: componentTemplateToClone,
    isLoading
  } = api.useLoadComponentTemplate(decodedSourceName);
  (0, _react.useEffect)(() => {
    if (error && !isLoading) {
      // Toasts expects a generic Error object, which is typed as having a required name property.
      toasts.addError({
        ...error,
        name: ''
      }, {
        title: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateClone.loadComponentTemplateTitle', {
          defaultMessage: `Error loading component template ''{sourceComponentTemplateName}''.`,
          values: {
            sourceComponentTemplateName
          }
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [error, isLoading]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.loadingDescription",
      defaultMessage: "Loading component template\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }));
  } else {
    // We still show the create form (unpopulated) even if we were not able to load the
    // selected component template data.
    const sourceComponentTemplate = componentTemplateToClone ? {
      ...componentTemplateToClone,
      name: `${componentTemplateToClone.name}-copy`
    } : undefined;
    return /*#__PURE__*/_react.default.createElement(_component_template_create.ComponentTemplateCreate, (0, _extends2.default)({}, props, {
      sourceComponentTemplate: sourceComponentTemplate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 12
      }
    }));
  }
};
exports.ComponentTemplateClone = ComponentTemplateClone;