"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.__IntlProvider = exports.FormattedRelative = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactIntl = require("react-intl");
var _intlUtils = require("@formatjs/intl-utils");
var _moment = _interopRequireDefault(require("moment"));
var _provider = require("./provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-i18n-react/src/compatiblity_layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Mimic `FormattedRelative` previous behavior from formatJS v2
 */
const FormattedRelative = ({
  value: valueInput,
  updateIntervalInSeconds
}) => {
  const valueDate = (0, _moment.default)(valueInput).isValid() ? (0, _moment.default)(valueInput).toDate() : new Date();
  const {
    value,
    unit
  } = (0, _intlUtils.selectUnit)(valueDate, new Date());
  return /*#__PURE__*/_react.default.createElement(_reactIntl.FormattedRelativeTime, {
    value: value,
    numeric: "auto",
    unit: unit,
    updateIntervalInSeconds: updateIntervalInSeconds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};

/**
 * Added for now while doing the i18n upgrade.
 * TODO: remove in a separate PR and update the 200+ test files we have using this to simply
 * use the `I18nProvider` and the `IntlShape` instead of `InjectedIntl`.
 */
exports.FormattedRelative = FormattedRelative;
const __IntlProvider = ({
  children
}) => {
  // Drop `locale` and `messages` since we define it inside `i18n`, we no longer pass it to the provider.
  return /*#__PURE__*/_react.default.createElement(_provider.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 10
    }
  }, children);
};
exports.__IntlProvider = __IntlProvider;