"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _url_template = require("../../helpers/url_template");
var _selection_tool_bar = require("./selection_tool_bar");
var _control_panel_tool_bar = require("./control_panel_tool_bar");
var _select_style = require("./select_style");
var _selected_node_editor = require("./selected_node_editor");
var _merge_candidates = require("./merge_candidates");
var _drill_downs = require("./drill_downs");
var _drill_down_icon_links = require("./drill_down_icon_links");
var _state_management = require("../../state_management");
var _selected_node_item = require("./selected_node_item");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/control_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ControlPanelComponent = ({
  workspace,
  liveResponseFields,
  urlTemplates,
  control,
  selectedNode,
  colors,
  mergeCandidates,
  onSetControl,
  selectSelected
}) => {
  const hasNodes = workspace.nodes.length === 0;
  const openUrlTemplate = template => {
    const url = template.url;
    const newUrl = url.replace(_url_template.urlTemplateRegex, template.encoder.encode(workspace));
    window.open(newUrl, '_blank');
  };
  const onSelectedFieldClick = node => {
    selectSelected(node);
    workspace.changeHandler();
  };
  const onDeselectNode = node => {
    workspace.deselectNode(node);
    workspace.changeHandler();
    onSetControl('none');
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "sidebar",
    css: [(0, _react2.css)`
          ${(0, _eui.useEuiShadow)('m')};
        `, styles.gphSidebar],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_control_panel_tool_bar.ControlPanelToolBar, {
    workspace: workspace,
    liveResponseFields: liveResponseFields,
    onSetControl: onSetControl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selectionsTitle', {
    defaultMessage: 'Selections'
  })), /*#__PURE__*/_react.default.createElement(_selection_tool_bar.SelectionToolBar, {
    workspace: workspace,
    onSetControl: onSetControl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.gphSelectionList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, workspace.selectedNodes.length === 0 && /*#__PURE__*/_react.default.createElement("p", {
    className: "help-block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.graph.sidebar.selections.noSelectionsHelpText', {
    defaultMessage: 'No selections. Click on vertices to add.'
  })), workspace.selectedNodes.map(node => /*#__PURE__*/_react.default.createElement(_selected_node_item.SelectedNodeItem, {
    key: node.id,
    node: node,
    isHighlighted: selectedNode === node,
    onSelectedFieldClick: onSelectedFieldClick,
    onDeselectNode: onDeselectNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_drill_down_icon_links.DrillDownIconLinks, {
    urlTemplates: urlTemplates,
    hasNodes: hasNodes,
    openUrlTemplate: openUrlTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), control === 'drillDowns' && /*#__PURE__*/_react.default.createElement(_drill_downs.DrillDowns, {
    urlTemplates: urlTemplates,
    openUrlTemplate: openUrlTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), control === 'style' && workspace.selectedNodes.length > 0 && /*#__PURE__*/_react.default.createElement(_select_style.SelectStyle, {
    workspace: workspace,
    colors: colors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), control === 'editLabel' && selectedNode && /*#__PURE__*/_react.default.createElement(_selected_node_editor.SelectedNodeEditor, {
    workspace: workspace,
    selectedNode: selectedNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), control === 'mergeTerms' && /*#__PURE__*/_react.default.createElement(_merge_candidates.MergeCandidates, {
    workspace: workspace,
    mergeCandidates: mergeCandidates,
    onSetControl: onSetControl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }));
};
const styles = {
  gphSidebar: euiThemeContext => (0, _react2.css)({
    position: 'absolute',
    right: euiThemeContext.euiTheme.size.s,
    top: euiThemeContext.euiTheme.size.s,
    width: `calc(${euiThemeContext.euiTheme.size.xl} * 10)`,
    zIndex: euiThemeContext.euiTheme.levels.flyout,
    // https://eui.elastic.co/#/theming/more-tokens#levels
    backgroundColor: euiThemeContext.euiTheme.colors.emptyShade,
    border: euiThemeContext.euiTheme.border.thin,
    padding: euiThemeContext.euiTheme.size.xs,
    borderRadius: euiThemeContext.euiTheme.border.radius.medium,
    opacity: 0.9,
    '.help-block': {
      fontSize: (0, _eui.euiFontSize)(euiThemeContext, 'xs', {
        unit: 'px'
      }).fontSize,
      color: euiThemeContext.euiTheme.colors.text
    }
  }),
  gphSelectionList: ({
    euiTheme
  }) => (0, _react2.css)({
    height: `calc(${euiTheme.size.l} * 10)`,
    backgroundColor: euiTheme.colors.lightestShade,
    overflow: 'auto',
    marginBottom: 0
  })
};
const ControlPanel = exports.ControlPanel = (0, _reactRedux.connect)(state => ({
  urlTemplates: (0, _state_management.templatesSelector)(state),
  liveResponseFields: (0, _state_management.liveResponseFieldsSelector)(state)
}))(ControlPanelComponent);