"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuggestions = ({
  searchTerm,
  searchableTypes,
  tagCache
}) => {
  const results = [];
  const suggestionTerm = searchTerm.trim();
  const matchingType = findIgnoreCase(searchableTypes, suggestionTerm);
  if (matchingType) {
    const suggestedSearch = escapeIfWhiteSpaces(matchingType);
    results.push({
      key: '__type__suggestion__',
      label: `type: ${matchingType}`,
      icon: 'filter',
      description: _i18n.i18n.translate('xpack.globalSearchBar.suggestions.filterByTypeLabel', {
        defaultMessage: 'Filter by type'
      }),
      suggestedSearch: `type:${suggestedSearch}`
    });
  }
  if (tagCache && searchTerm) {
    const matchingTag = tagCache.getState().find(tag => equalsIgnoreCase(tag.name, suggestionTerm));
    if (matchingTag) {
      const suggestedSearch = escapeIfWhiteSpaces(matchingTag.name);
      results.push({
        key: '__tag__suggestion__',
        label: `tag: ${matchingTag.name}`,
        icon: 'tag',
        description: _i18n.i18n.translate('xpack.globalSearchBar.suggestions.filterByTagLabel', {
          defaultMessage: 'Filter by tag name'
        }),
        suggestedSearch: `tag:${suggestedSearch}`
      });
    }
  }
  return results;
};
exports.getSuggestions = getSuggestions;
const findIgnoreCase = (array, target) => {
  for (const item of array) {
    if (equalsIgnoreCase(item, target)) {
      return item;
    }
  }
  return undefined;
};
const equalsIgnoreCase = (a, b) => a.toLowerCase() === b.toLowerCase();
const escapeIfWhiteSpaces = term => {
  if (/\s/g.test(term)) {
    return `"${term}"`;
  }
  return term;
};