"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumTransformAssets = exports.TransformInstallWithCurrentUserPermissionCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/transform_install_as_current_user_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getNumTransformAssets = assets => {
  var _assets$elasticsearch, _assets$elasticsearch2, _assets$elasticsearch3, _assets$elasticsearch4, _assets$elasticsearch5;
  if (!assets || !(Array.isArray((_assets$elasticsearch = assets.elasticsearch) === null || _assets$elasticsearch === void 0 ? void 0 : _assets$elasticsearch.transform) && ((_assets$elasticsearch2 = (_assets$elasticsearch3 = assets.elasticsearch) === null || _assets$elasticsearch3 === void 0 ? void 0 : (_assets$elasticsearch4 = _assets$elasticsearch3.transform) === null || _assets$elasticsearch4 === void 0 ? void 0 : _assets$elasticsearch4.length) !== null && _assets$elasticsearch2 !== void 0 ? _assets$elasticsearch2 : 0) > 0)) {
    return 0;
  }
  return (0, _lodash.uniqBy)((_assets$elasticsearch5 = assets.elasticsearch) === null || _assets$elasticsearch5 === void 0 ? void 0 : _assets$elasticsearch5.transform, 'file').length;
};
exports.getNumTransformAssets = getNumTransformAssets;
const TransformInstallWithCurrentUserPermissionCallout = ({
  count
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.transformInstallWithCurrentUserPermissionCallout.text",
    defaultMessage: "This package has {count, plural, one {one} other {#}} {docsLink} which will be created and started with the same roles as the user installing the package.",
    values: {
      count,
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.transforms.overview,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.transformInstallWithCurrentUserPermissionCallout.docsLink",
        defaultMessage: "{count, plural, one {transform asset} other {transform assets}}",
        values: {
          count
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
};
exports.TransformInstallWithCurrentUserPermissionCallout = TransformInstallWithCurrentUserPermissionCallout;