"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeferredAssetDescription = exports.DeferredAssetsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../../../hooks");
var _constants = require("../../../constants");
var _types = require("../../../../../types");
var _models = require("../../../../../../../../common/types/models");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/assets/deferred_assets_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDeferredAssetDescription = (assetType, assetCount, permissions) => {
  switch (assetType) {
    case _types.ElasticsearchAssetType.transform:
      if (permissions.canEdit) {
        return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredTransformReauthorizeDescription', {
          defaultMessage: '{assetCount, plural, one {Transform was installed but requires} other {# transforms were installed but require}} additional permissions to run. Reauthorize the {assetCount, plural, one {transform} other {transforms}} to start operations.',
          values: {
            assetCount: assetCount !== null && assetCount !== void 0 ? assetCount : 1
          }
        });
      }
      return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredTransformRequestPermissionDescription', {
        defaultMessage: '{assetCount, plural, one {Transform was installed but requires} other {# transforms were installed but require}} additional permissions to run. Contact your administrator to request the required privileges.',
        values: {
          assetCount: assetCount !== null && assetCount !== void 0 ? assetCount : 1
        }
      });
    default:
      return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsDescription', {
        defaultMessage: 'Asset requires additional permissions.'
      });
  }
};
exports.getDeferredAssetDescription = getDeferredAssetDescription;
const DeferredAssetsAccordion = ({
  packageInfo,
  type,
  deferredInstallations,
  forceRefreshAssets
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const deferredAssets = (0, _react.useMemo)(() => deferredInstallations.map(i => ({
    id: i.id,
    attributes: {
      title: i.id,
      description: i.type
    }
  })), [deferredInstallations]);
  const authz = (0, _hooks.useAuthz)();
  const canEdit = (0, _react.useMemo)(() => {
    if (type === _types.ElasticsearchAssetType.transform) {
      var _authz$packagePrivile, _authz$packagePrivile2, _authz$packagePrivile3, _authz$packagePrivile4, _authz$packagePrivile5;
      return (_authz$packagePrivile = (_authz$packagePrivile2 = authz.packagePrivileges) === null || _authz$packagePrivile2 === void 0 ? void 0 : (_authz$packagePrivile3 = _authz$packagePrivile2.transform) === null || _authz$packagePrivile3 === void 0 ? void 0 : (_authz$packagePrivile4 = _authz$packagePrivile3.actions) === null || _authz$packagePrivile4 === void 0 ? void 0 : (_authz$packagePrivile5 = _authz$packagePrivile4.canStartStopTransform) === null || _authz$packagePrivile5 === void 0 ? void 0 : _authz$packagePrivile5.executePackageAction) !== null && _authz$packagePrivile !== void 0 ? _authz$packagePrivile : false;
    } else if (type === _models.KibanaSavedObjectType.alert) {
      var _authz$integrations;
      return (_authz$integrations = authz.integrations) === null || _authz$integrations === void 0 ? void 0 : _authz$integrations.installPackages;
    }
    return false;
  }, [type, authz]);
  const authorizeTransforms = (0, _react.useCallback)(async transformIds => {
    setIsLoading(true);
    notifications.toasts.addInfo(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsAcknowledged', {
      defaultMessage: 'Request to authorize {count, plural, one {# transform} other {# transforms}} acknowledged.',
      values: {
        count: transformIds.length
      }
    }), {
      toastLifeTimeMs: 500
    });
    try {
      const reauthorizeTransformResp = await (0, _hooks.sendRequestReauthorizeTransforms)(packageInfo.name, packageInfo.version, transformIds);
      if (Array.isArray(reauthorizeTransformResp)) {
        var _reauthorizeTransform;
        const error = (_reauthorizeTransform = reauthorizeTransformResp.find(d => d.error)) === null || _reauthorizeTransform === void 0 ? void 0 : _reauthorizeTransform.error;
        const cntAuthorized = reauthorizeTransformResp.filter(d => d.success).length;
        if (error) {
          var _error$meta, _errorBody$error, _errorBody$error2;
          const errorBody = (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body;
          const errorMsg = errorBody ? `${(_errorBody$error = errorBody.error) === null || _errorBody$error === void 0 ? void 0 : _errorBody$error.type}: ${(_errorBody$error2 = errorBody.error) === null || _errorBody$error2 === void 0 ? void 0 : _errorBody$error2.reason}` : `${error.message}`;
          notifications.toasts.addError({
            name: errorMsg,
            message: errorMsg
          }, {
            title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsUnsuccessful', {
              defaultMessage: 'Unable to authorize {cntUnauthorized, plural, one {# transform} other {# transforms}}.',
              values: {
                cntUnauthorized: transformIds.length - cntAuthorized
              }
            }),
            toastLifeTimeMs: 1000
          });
        } else {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.authorizeTransformsSuccessful', {
            defaultMessage: 'Successfully authorized {count, plural, one {# transform} other {# transforms}}.',
            values: {
              count: cntAuthorized
            }
          }), {
            toastLifeTimeMs: 1000
          });
        }
      }
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.unableToAuthorizeAllTransformsError', {
          defaultMessage: 'An error occurred authorizing and starting transforms.'
        })
      });
    }
    if (forceRefreshAssets) {
      forceRefreshAssets();
    }
    setIsLoading(false);
  }, [notifications.toasts, packageInfo.name, packageInfo.version, forceRefreshAssets]);
  const createRules = (0, _react.useCallback)(async alertIds => {
    setIsLoading(true);
    notifications.toasts.addInfo(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.creatingRules', {
      defaultMessage: 'Creating {count, plural, one {# rule} other {# rules}}.',
      values: {
        count: alertIds.length
      }
    }), {
      toastLifeTimeMs: 500
    });
    try {
      await (0, _hooks.sendRequestInstallRuleAssets)(packageInfo.name, packageInfo.version);
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.createRulesSuccess', {
        defaultMessage: 'Successfully created {count, plural, one {# rule} other {# rules}}.',
        values: {
          count: alertIds.length
        }
      }), {
        toastLifeTimeMs: 1000
      });
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.createRulesError', {
          defaultMessage: 'An error occurred creating rules.'
        })
      });
    }
    if (forceRefreshAssets) {
      forceRefreshAssets();
    }
    setIsLoading(false);
  }, [notifications.toasts, packageInfo.name, packageInfo.version, forceRefreshAssets]);
  if (deferredAssets.length === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 15
      }
    }, _constants.AssetTitleMap[type]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "accent",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 15
      }
    }, deferredAssets.length)))),
    id: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, getDeferredAssetDescription(type, deferredInstallations.length, {
    canEdit
  }), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subject": `fleetAssetsReauthorizeAll`,
    disabled: !canEdit,
    isLoading: isLoading,
    size: 'm',
    onClick: e => {
      e.preventDefault();
      if (type === _types.ElasticsearchAssetType.transform) {
        authorizeTransforms(deferredAssets.map(t => ({
          transformId: t.id
        })));
      } else if (type === _models.KibanaSavedObjectType.alert) {
        createRules(deferredAssets.map(({
          id
        }) => id));
      }
    },
    "aria-label": getDeferredAssetDescription(type, deferredInstallations.length, {
      canEdit
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }, type === _types.ElasticsearchAssetType.transform ? _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeAllButton', {
    defaultMessage: 'Reauthorize all'
  }) : null, type === _models.KibanaSavedObjectType.alert ? _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.createRulesButton', {
    defaultMessage: 'Create rules'
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 9
    }
  }, deferredAssets.map(({
    id: assetId
  }, idx) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: assetId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      grow: false,
      key: `${assetId}-${idx}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 8,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 25
      }
    }, assetId))), type === _types.ElasticsearchAssetType.transform ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: canEdit ? undefined : getDeferredAssetDescription(type, 1, {
        canEdit
      }),
      "data-test-subject": `fleetAssetsReauthorizeTooltip-${assetId}-${isLoading}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isLoading,
      disabled: !canEdit,
      size: 's',
      onClick: e => {
        e.preventDefault();
        authorizeTransforms([{
          transformId: assetId
        }]);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 27
      }
    }, _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeButton', {
      defaultMessage: 'Reauthorize'
    })))) : null)), idx + 1 < deferredAssets.length && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 53
      }
    }));
  }))));
};
exports.DeferredAssetsAccordion = DeferredAssetsAccordion;