"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDowloadSourceFlyoutForm = useDowloadSourceFlyoutForm;
exports.validateHost = validateHost;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _confirm_update = require("./confirm_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDowloadSourceFlyoutForm(onSuccess, downloadSource) {
  var _downloadSource$name, _downloadSource$is_de, _downloadSource$host, _downloadSource$proxy, _downloadSource$ssl$c, _downloadSource$ssl, _downloadSource$ssl$c2, _downloadSource$ssl2, _downloadSource$ssl$k, _downloadSource$ssl3, _secrets, _secrets$ssl;
  const authz = (0, _hooks.useAuthz)();
  const [isLoading, setIsloading] = (0, _react.useState)(false);
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const isEditDisabled = !authz.fleet.allSettings;
  const nameInput = (0, _hooks.useInput)((_downloadSource$name = downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.name) !== null && _downloadSource$name !== void 0 ? _downloadSource$name : '', validateName, isEditDisabled);
  const defaultDownloadSourceInput = (0, _hooks.useSwitchInput)((_downloadSource$is_de = downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.is_default) !== null && _downloadSource$is_de !== void 0 ? _downloadSource$is_de : false, (downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.is_default) || isEditDisabled);
  const hostInput = (0, _hooks.useInput)((_downloadSource$host = downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.host) !== null && _downloadSource$host !== void 0 ? _downloadSource$host : '', validateHost, isEditDisabled);
  const proxyIdInput = (0, _hooks.useInput)((_downloadSource$proxy = downloadSource === null || downloadSource === void 0 ? void 0 : downloadSource.proxy_id) !== null && _downloadSource$proxy !== void 0 ? _downloadSource$proxy : '', () => undefined, isEditDisabled);
  const sslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslCertificateAuthoritiesComboxBox', (_downloadSource$ssl$c = downloadSource === null || downloadSource === void 0 ? void 0 : (_downloadSource$ssl = downloadSource.ssl) === null || _downloadSource$ssl === void 0 ? void 0 : _downloadSource$ssl.certificate_authorities) !== null && _downloadSource$ssl$c !== void 0 ? _downloadSource$ssl$c : [], undefined, undefined);
  const sslCertificateInput = (0, _hooks.useInput)((_downloadSource$ssl$c2 = downloadSource === null || downloadSource === void 0 ? void 0 : (_downloadSource$ssl2 = downloadSource.ssl) === null || _downloadSource$ssl2 === void 0 ? void 0 : _downloadSource$ssl2.certificate) !== null && _downloadSource$ssl$c2 !== void 0 ? _downloadSource$ssl$c2 : '', undefined, undefined);
  const sslKeyInput = (0, _hooks.useInput)((_downloadSource$ssl$k = downloadSource === null || downloadSource === void 0 ? void 0 : (_downloadSource$ssl3 = downloadSource.ssl) === null || _downloadSource$ssl3 === void 0 ? void 0 : _downloadSource$ssl3.key) !== null && _downloadSource$ssl$k !== void 0 ? _downloadSource$ssl$k : '', undefined, undefined);
  const sslKeySecretInput = (0, _hooks.useSecretInput)(downloadSource === null || downloadSource === void 0 ? void 0 : (_secrets = downloadSource.secrets) === null || _secrets === void 0 ? void 0 : (_secrets$ssl = _secrets.ssl) === null || _secrets$ssl === void 0 ? void 0 : _secrets$ssl.key, undefined, undefined);
  const inputs = {
    nameInput,
    hostInput,
    defaultDownloadSourceInput,
    proxyIdInput,
    sslCertificateInput,
    sslKeyInput,
    sslCertificateAuthoritiesInput,
    sslKeySecretInput
  };
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const validate = (0, _react.useCallback)(() => {
    const nameInputValid = nameInput.validate();
    const hostValid = hostInput.validate();
    const sslCertificateValid = sslCertificateInput.validate();
    const sslKeyValid = sslKeyInput.validate();
    const sslKeySecretValid = sslKeySecretInput.validate();
    return nameInputValid && hostValid && sslCertificateValid && sslKeyValid && sslKeySecretValid;
  }, [nameInput, hostInput, sslCertificateInput, sslKeyInput, sslKeySecretInput]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      setIsloading(true);
      const data = {
        name: nameInput.value.trim(),
        host: hostInput.value.trim(),
        is_default: defaultDownloadSourceInput.value,
        proxy_id: proxyIdInput.value || null,
        ssl: {
          certificate: sslCertificateInput.value,
          key: sslKeyInput.value || undefined,
          certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== '')
        },
        ...(!sslKeyInput.value && sslKeySecretInput.value && {
          secrets: {
            ssl: {
              key: sslKeySecretInput.value || undefined
            }
          }
        })
      };
      if (downloadSource) {
        // Update
        if (!(await (0, _confirm_update.confirmUpdate)(downloadSource, confirm))) {
          setIsloading(false);
          return;
        }
        const res = await (0, _hooks.sendPutDownloadSource)(downloadSource.id, data);
        if (res.error) {
          throw res.error;
        }
      } else {
        // Create
        const res = await (0, _hooks.sendPostDownloadSource)(data);
        if (res.error) {
          throw res.error;
        }
      }
      onSuccess();
      setIsloading(false);
    } catch (err) {
      setIsloading(false);
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.dowloadSourceFlyoutForm.errorToastTitle', {
          defaultMessage: 'Error while saving binary source'
        })
      });
    }
  }, [confirm, defaultDownloadSourceInput.value, downloadSource, hostInput.value, nameInput.value, notifications.toasts, onSuccess, proxyIdInput.value, sslCertificateAuthoritiesInput.value, sslCertificateInput.value, sslKeyInput.value, sslKeySecretInput.value, validate]);
  return {
    inputs,
    submit,
    isLoading,
    isDisabled: isLoading || downloadSource && !hasChanged || isEditDisabled
  };
}
function validateName(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.dowloadSourceFlyoutForm.nameIsRequiredErrorMessage', {
      defaultMessage: 'Name is required'
    })];
  }
}
function validateHost(value) {
  try {
    if (!value) {
      return [_i18n.i18n.translate('xpack.fleet.settings.dowloadSourceFlyoutForm.HostIsRequiredErrorMessage', {
        defaultMessage: 'Host is required'
      })];
    }
    const urlParsed = new URL(value);
    if (!['http:', 'https:'].includes(urlParsed.protocol)) {
      throw new Error('Invalid protocol');
    }
  } catch (error) {
    return [_i18n.i18n.translate('xpack.fleet.settings.dowloadSourceFlyoutForm.hostError', {
      defaultMessage: 'Invalid URL'
    })];
  }
}