"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPackagePolicies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _add_integration_flyout = require("./add_integration_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/package_policies/no_package_policies.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoPackagePolicies = exports.NoPackagePolicies = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy,
  refreshAgentPolicy
}) => {
  const authz = (0, _hooks.useAuthz)();
  const canWriteIntegrationPolicies = authz.integrations.writeIntegrationPolicies && authz.fleet.allAgentPolicies;
  const [showAddIntegrationFlyout, setShowAddIntegrationFlyout] = _react.default.useState(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "plusInCircle",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",
      defaultMessage: "Add your first integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 15
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",
      defaultMessage: "This policy does not have any integrations yet.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 13
      }
    }),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      isDisabled: !canWriteIntegrationPolicies,
      fill: true,
      onClick: () => {
        setShowAddIntegrationFlyout(true);
      },
      "data-test-subj": "addPackagePolicyButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",
      defaultMessage: "Add integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }), showAddIntegrationFlyout && /*#__PURE__*/_react.default.createElement(_add_integration_flyout.AddIntegrationFlyout, {
    onClose: () => {
      setShowAddIntegrationFlyout(false);
      refreshAgentPolicy();
    },
    agentPolicy: agentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }));
});