"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectedRoute = void 0;
exports.renderApp = renderApp;
exports.teardownFleet = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _hooks = require("./hooks");
var _app = require("./app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProtectedRoute = ({
  isAllowed = false,
  restrictedPath = '/',
  ...routeProps
}) => {
  return isAllowed ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({}, routeProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 22
    }
  })) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: restrictedPath
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 50
    }
  });
};
exports.ProtectedRoute = ProtectedRoute;
const FleetApp = ({
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  setHeaderActionMenu
}) => {
  return /*#__PURE__*/_react.default.createElement(_app.FleetAppContext, {
    startServices: startServices,
    config: config,
    history: history,
    kibanaVersion: kibanaVersion,
    extensions: extensions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_app.WithPermissionsAndSetup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_app.AppRoutes, {
    setHeaderActionMenu: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })));
};
function renderApp(startServices, {
  element,
  history,
  setHeaderActionMenu
}, config, kibanaVersion, extensions) {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(FleetApp, {
    startServices: startServices,
    config: config,
    history: history,
    kibanaVersion: kibanaVersion,
    extensions: extensions,
    setHeaderActionMenu: setHeaderActionMenu,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
}
const teardownFleet = coreStart => {
  coreStart.chrome.docTitle.reset();
  coreStart.chrome.setBreadcrumbs([]);
  _hooks.licenseService.stop();
};
exports.teardownFleet = teardownFleet;