"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportCompleteView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _kibana_services = require("../kibana_services");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/components/import_complete_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const services = {
  uiSettings: (0, _kibana_services.getUiSettings)(),
  settings: (0, _kibana_services.getSettings)(),
  theme: (0, _kibana_services.getTheme)()
};
const STATUS_CALLOUT_DATA_TEST_SUBJ = 'fileUploadStatusCallout';
class ImportCompleteView extends _react.Component {
  _renderCodeEditor(json, title, copyButtonDataTestSubj) {
    if (!json) {
      return null;
    }
    const jsonAsString = JSON.stringify(json, null, 2);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: jsonAsString,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      onClick: copy,
      iconType: "copy",
      color: "text",
      "data-test-subj": copyButtonDataTestSubj,
      "aria-label": _i18n.i18n.translate('xpack.fileUpload.importComplete.copyButtonAriaLabel', {
        defaultMessage: 'Copy to clipboard'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '200px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      languageId: "json",
      value: jsonAsString,
      options: {
        readOnly: true,
        lineNumbers: 'off',
        fontSize: 12,
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }));
  }
  _getStatusMsg() {
    var _this$props$importRes7;
    if (this.props.failedPermissionCheck) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadFailureTitle', {
          defaultMessage: 'Unable to upload file'
        }),
        color: "danger",
        iconType: "warning",
        "data-test-subj": STATUS_CALLOUT_DATA_TEST_SUBJ,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.fileUpload.importComplete.permissionFailureMsg', {
        defaultMessage: 'You do not have permission to create or import data into index "{indexName}".',
        values: {
          indexName: this.props.indexName
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _kibana_services.getDocLinks)().links.maps.importGeospatialPrivileges,
        target: "_blank",
        external: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.fileUpload.importComplete.permission.docLink', {
        defaultMessage: 'View file import permissions'
      })));
    }
    if (!this.props.importResults || !this.props.importResults.success) {
      var _this$props$importRes, _this$props$importRes2, _this$props$importRes3, _this$props$importRes4, _this$props$importRes5, _this$props$importRes6;
      let reason;
      if ((_this$props$importRes = this.props.importResults) !== null && _this$props$importRes !== void 0 && (_this$props$importRes2 = _this$props$importRes.error) !== null && _this$props$importRes2 !== void 0 && (_this$props$importRes3 = _this$props$importRes2.body) !== null && _this$props$importRes3 !== void 0 && _this$props$importRes3.message) {
        // Display http request error message
        reason = this.props.importResults.error.body.message;
      } else if ((_this$props$importRes4 = this.props.importResults) !== null && _this$props$importRes4 !== void 0 && (_this$props$importRes5 = _this$props$importRes4.error) !== null && _this$props$importRes5 !== void 0 && (_this$props$importRes6 = _this$props$importRes5.error) !== null && _this$props$importRes6 !== void 0 && _this$props$importRes6.reason) {
        // Display elasticsearch request error message
        reason = this.props.importResults.error.error.reason;
      }
      const errorMsg = reason ? _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadFailureMsgErrorBlock', {
        defaultMessage: 'Error: {reason}',
        values: {
          reason
        }
      }) : '';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadFailureTitle', {
          defaultMessage: 'Unable to upload file'
        }),
        color: "danger",
        iconType: "warning",
        "data-test-subj": STATUS_CALLOUT_DATA_TEST_SUBJ,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 11
        }
      }, errorMsg));
    }
    if ((_this$props$importRes7 = this.props.importResults.failures) !== null && _this$props$importRes7 !== void 0 && _this$props$importRes7.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadSuccessWithFailuresTitle', {
          defaultMessage: 'File upload complete with failures'
        }),
        color: "warning",
        iconType: "question",
        "data-test-subj": STATUS_CALLOUT_DATA_TEST_SUBJ,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 11
        }
      }, (0, _utils.getPartialImportMessage)(this.props.importResults.failures.length, this.props.importResults.docCount)));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadSuccessTitle', {
        defaultMessage: 'File upload complete'
      }),
      "data-test-subj": STATUS_CALLOUT_DATA_TEST_SUBJ,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fileUpload.importComplete.uploadSuccessMsg', {
      defaultMessage: 'Indexed {numFeatures} features.',
      values: {
        numFeatures: this.props.importResults.docCount
      }
    })));
  }
  _renderIndexManagementMsg() {
    return this.props.importResults && this.props.importResults.success ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fileUpload.importComplete.indexModsMsg",
      defaultMessage: "To modify the index, go to ",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("a", {
      "data-test-subj": "indexManagementNewIndexLink",
      target: "_blank",
      href: (0, _kibana_services.getHttp)().basePath.prepend('/app/management/data/index_management/indices'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fileUpload.importComplete.indexMgmtLink",
      defaultMessage: "Index Management.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    })))) : null;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: services,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 7
      }
    }, this._getStatusMsg(), this._renderCodeEditor(this.props.importResults, _i18n.i18n.translate('xpack.fileUpload.importComplete.indexingResponse', {
      defaultMessage: 'Import response'
    }), 'indexRespCopyButton'), this._renderCodeEditor(this.props.dataViewResp, _i18n.i18n.translate('xpack.fileUpload.importComplete.dataViewResponse', {
      defaultMessage: 'Data view response'
    }), 'dataViewRespCopyButton'), this._renderIndexManagementMsg());
  }
}
exports.ImportCompleteView = ImportCompleteView;