"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelsFieldFilter = LabelsFieldFilter;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _filter_values_list = require("./filter_values_list");
var _use_filter_values = require("../use_filter_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/components/labels_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LabelsFieldFilter(props) {
  const {
    series
  } = props;
  const [query, setQuery] = (0, _react.useState)('');
  const {
    dataView
  } = (0, _use_app_data_view.useAppDataViewContext)(series.dataType);
  const labelFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => field.name.startsWith('labels.'));
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    iconSide: "right",
    isSelected: isPopoverOpen,
    onClick: onButtonClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, LABELS_LABEL);
  const [selectedLabel, setSelectedLabel] = (0, _react.useState)('');
  const {
    values,
    loading
  } = (0, _use_filter_values.useFilterValues)({
    ...props,
    field: selectedLabel
  }, query);
  const labelFieldOptions = (labelFields !== null && labelFields !== void 0 ? labelFields : []).map(field => {
    return {
      label: field.name,
      searchableLabel: field.name,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowRight",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 15
        }
      }),
      showIcons: false
    };
  });
  labelFieldOptions.unshift({
    label: LABELS_FIELDS_LABEL,
    isGroupLabel: true
  });
  const closePopover = () => {
    setPopover(false);
    setSelectedLabel('');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, selectedLabel ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yLabelsFieldFilterButton",
    iconType: "arrowLeft",
    iconSide: "left",
    onClick: () => setSelectedLabel(''),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, BACK_TO_LABEL)), /*#__PURE__*/_react.default.createElement(_filter_values_list.FilterValuesList, (0, _extends2.default)({}, props, {
    label: selectedLabel,
    values: values,
    query: query,
    setQuery: setQuery,
    loading: loading,
    field: selectedLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    options: labelFieldOptions,
    onChange: optionsChange => {
      var _checked$label;
      const checked = optionsChange.find(option => option.checked === 'on');
      setSelectedLabel((_checked$label = checked === null || checked === void 0 ? void 0 : checked.label) !== null && _checked$label !== void 0 ? _checked$label : '');
    },
    listProps: {
      onFocusBadge: false
    },
    height: 450,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, search, list)));
}
const LABELS_LABEL = _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.labels.label', {
  defaultMessage: 'Labels'
});
const LABELS_FIELDS_LABEL = _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.labels.fields', {
  defaultMessage: 'Label fields'
});
const BACK_TO_LABEL = _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.labels.backTo', {
  defaultMessage: 'Back to labels'
});