"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesName = SeriesName;
exports.StyledText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/series_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledText = exports.StyledText = (0, _styled.default)(_eui.EuiText)`
  &.euiText.euiText--constrainedWidth {
    max-width: 200px;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
  }
`;
function SeriesName({
  series,
  seriesId
}) {
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [value, setValue] = (0, _react.useState)(series.name);
  const [isEditingEnabled, setIsEditingEnabled] = (0, _react.useState)(false);
  const inputRef = (0, _react.useRef)(null);
  const buttonRef = (0, _react.useRef)(null);
  const onChange = e => {
    setValue(e.target.value);
  };
  const onSave = () => {
    if (value !== series.name) {
      setSeries(seriesId, {
        ...series,
        name: value
      });
    }
  };
  const onOutsideClick = event => {
    if (event.target !== buttonRef.current) {
      setIsEditingEnabled(false);
      onSave();
    }
  };
  const onKeyDown = event => {
    if (event.key === 'Enter') {
      setIsEditingEnabled(false);
      onSave();
    }
  };
  (0, _react.useEffect)(() => {
    setValue(series.name);
  }, [series.name]);
  (0, _react.useEffect)(() => {
    if (isEditingEnabled && inputRef.current) {
      inputRef.current.focus();
    }
  }, [isEditingEnabled, inputRef]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, isEditingEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onOutsideClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: value,
    onChange: onChange,
    onBlur: onSave,
    onKeyDown: onKeyDown,
    fullWidth: true,
    inputRef: inputRef,
    "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.seriesName', {
      defaultMessage: 'Series name'
    }),
    "data-test-subj": "exploratoryViewSeriesNameInput",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledText, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "exploratoryViewSeriesNameButton",
    onClick: () => setIsEditingEnabled(!isEditingEnabled),
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.editName', {
      defaultMessage: 'Edit name'
    }),
    color: "text",
    buttonRef: buttonRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
}