"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncompleteBadge = IncompleteBadge;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_app_data_view = require("../../hooks/use_app_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/incomplete_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IncompleteBadge({
  seriesConfig,
  series
}) {
  var _definitionFields$;
  const {
    loading
  } = (0, _use_app_data_view.useAppDataViewContext)();
  if (!seriesConfig) {
    return null;
  }
  const {
    dataType,
    reportDefinitions,
    selectedMetricField
  } = series;
  const {
    definitionFields,
    labels
  } = seriesConfig;
  const isIncomplete = (!dataType || (0, _lodash.isEmpty)(reportDefinitions) || !selectedMetricField) && !loading;
  const incompleteDefinition = (0, _lodash.isEmpty)(reportDefinitions) ? _i18n.i18n.translate('xpack.exploratoryView.missingReportDefinition', {
    defaultMessage: 'Missing {reportDefinition}',
    values: {
      reportDefinition: labels === null || labels === void 0 ? void 0 : labels[typeof definitionFields[0] === 'string' ? definitionFields[0] : (_definitionFields$ = definitionFields[0]) === null || _definitionFields$ === void 0 ? void 0 : _definitionFields$.field]
    }
  }) : '';
  let incompleteMessage = !selectedMetricField ? MISSING_REPORT_METRIC_LABEL : incompleteDefinition;
  if (!dataType) {
    incompleteMessage = MISSING_DATA_TYPE_LABEL;
  }
  if (!isIncomplete) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 10
    }
  }, incompleteMessage);
}
const MISSING_REPORT_METRIC_LABEL = _i18n.i18n.translate('xpack.exploratoryView.missingReportMetric', {
  defaultMessage: 'Missing report metric'
});
const MISSING_DATA_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.missingDataType', {
  defaultMessage: 'Missing data type'
});