"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Embeddable;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_ebt_telemetry = require("../hooks/use_ebt_telemetry");
var _operation_type_select = require("../series_editor/columns/operation_type_select");
var _use_actions = require("./use_actions");
var _add_to_case_action = require("../header/add_to_case_action");
var _use_embeddable_attributes = require("./use_embeddable_attributes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/embeddable/embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-default-export
function Embeddable(props) {
  var _Object$entries$;
  const {
    appendTitle,
    attributes = [],
    axisTitlesVisibility,
    gridlinesVisibilitySettings,
    customHeight,
    customTimeRange,
    legendIsVisible,
    legendPosition,
    lens,
    onBrushEnd,
    caseOwner = _public.observabilityFeatureId,
    reportType,
    showCalculationMethod = false,
    title,
    withActions = true,
    hideTicks,
    align,
    noLabel,
    fontSize = 27,
    lineHeight = 32,
    searchSessionId,
    onLoad,
    analytics
  } = props;
  const LensComponent = lens === null || lens === void 0 ? void 0 : lens.EmbeddableComponent;
  const LensSaveModalComponent = lens === null || lens === void 0 ? void 0 : lens.SaveModalComponent;
  const [isSaveOpen, setIsSaveOpen] = (0, _react.useState)(false);
  const [isAddToCaseOpen, setAddToCaseOpen] = (0, _react.useState)(false);
  const series = (_Object$entries$ = Object.entries(attributes)[0]) === null || _Object$entries$ === void 0 ? void 0 : _Object$entries$[1];
  const [operationType, setOperationType] = (0, _react.useState)(series === null || series === void 0 ? void 0 : series.operationType);
  const attributesJSON = (0, _use_embeddable_attributes.useEmbeddableAttributes)(props);
  const timeRange = customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : series === null || series === void 0 ? void 0 : series.time;
  const {
    reportEvent
  } = (0, _use_ebt_telemetry.useEBTTelemetry)({
    analytics,
    queryName: series ? `${series.dataType}_${series.name}` : typeof title === 'string' ? title : 'Exp View embeddable query'
  });
  const actions = (0, _use_actions.useActions)({
    withActions,
    attributes,
    reportType,
    setIsSaveOpen,
    setAddToCaseOpen,
    lensAttributes: attributesJSON,
    timeRange
  });
  if (!attributesJSON) {
    return null;
  }
  if (typeof axisTitlesVisibility !== 'undefined') {
    attributesJSON.state.visualization.axisTitlesVisibilitySettings = axisTitlesVisibility;
  }
  if (typeof gridlinesVisibilitySettings !== 'undefined') {
    attributesJSON.state.visualization.gridlinesVisibilitySettings = gridlinesVisibilitySettings;
  }
  if (typeof legendIsVisible !== 'undefined') {
    attributesJSON.state.visualization.legend.isVisible = legendIsVisible;
  }
  if (typeof legendPosition !== 'undefined') {
    attributesJSON.state.visualization.legend.position = legendPosition;
  }
  if (hideTicks) {
    attributesJSON.state.visualization.tickLabelsVisibilitySettings = {
      x: false,
      yRight: false,
      yLeft: false
    };
  }
  if (!attributesJSON) {
    return null;
  }
  if (!LensComponent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.exploratoryView.embeddable.noLensComponentTextLabel', {
      defaultMessage: 'No lens component'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    $customHeight: customHeight,
    align: align,
    noLabel: noLabel,
    fontSize: fontSize,
    lineHeight: lineHeight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, (title || showCalculationMethod || appendTitle) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "exploratoryView-title",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, title))), showCalculationMethod && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 150
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_operation_type_select.OperationTypeComponent, {
    operationType: operationType,
    onChange: val => {
      setOperationType(val);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  })), appendTitle && appendTitle), /*#__PURE__*/_react.default.createElement(LensComponent, {
    id: "exploratoryView",
    "data-test-subj": "exploratoryView",
    style: {
      height: '100%'
    },
    timeRange: timeRange,
    attributes: {
      ...attributesJSON,
      title: '',
      description: ''
    },
    onBrushEnd: onBrushEnd,
    withDefaultActions: Boolean(withActions),
    extraActions: actions,
    viewMode: 'view',
    searchSessionId: searchSessionId,
    onLoad: (loading, inspectorAdapters) => {
      reportEvent(inspectorAdapters);
      onLoad === null || onLoad === void 0 ? void 0 : onLoad(loading);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), isSaveOpen && attributesJSON && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: {
      attributes: attributesJSON
    },
    onClose: () => setIsSaveOpen(false)
    // if we want to do anything after the viz is saved
    // right now there is no action, so an empty function
    ,
    onSave: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_case_action.AddToCaseAction, {
    lensAttributes: attributesJSON,
    timeRange: customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : series === null || series === void 0 ? void 0 : series.time,
    autoOpen: isAddToCaseOpen,
    setAutoOpen: setAddToCaseOpen,
    owner: caseOwner,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }));
}
const Wrapper = _styled.default.div`
  height: ${props => props.$customHeight ? `${props.$customHeight};` : `100%;`};
  position: relative;
  min-width: 80px;
  &&& {
    > :nth-child(2) {
      height: ${props => props.$customHeight ? `${props.$customHeight};` : `calc(100% - 32px);`};
    }
    .expExpressionRenderer__expression {
      padding: 0 !important;
    }

    .legacyMtrVis {
      > :first-child {
        justify-content: ${props => props.align === 'left' ? `flex-start;` : props.align === 'right' ? `flex-end;` : 'center;'};
      }
      justify-content: flex-end;
      &__container {
        padding: 0;
        [data-test-subj='metric_label'] {
          ${({
  noLabel
}) => noLabel && ` display: none;
        `}
        }
      }
      &__value {
        line-height: ${({
  lineHeight
}) => lineHeight}px !important;
        font-size: ${({
  fontSize
}) => fontSize}px !important;
      }
      > :first-child {
        transform: none !important;
      }
    }

    .euiLoadingChart {
      position: absolute;
      top: 50%;
      right: 50%;
      transform: translate(50%, -50%);
    }
  }
`;
module.exports = exports.default;