"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSingleMetricConfig = getSingleMetricConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSingleMetricConfig({
  dataView
}) {
  return {
    defaultSeriesType: 'line',
    xAxisColumn: {},
    yAxisColumns: [{
      operationType: 'median'
    }],
    breakdownFields: [],
    filterFields: [],
    seriesTypes: [],
    hasOperationType: true,
    definitionFields: ['service.name'],
    reportType: 'single-metric',
    baseFilters: [...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.TRANSACTION_TYPE, 'page-load', dataView), ...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.PROCESSOR_EVENT, 'transaction', dataView)],
    metricOptions: [{
      id: 'page_views',
      field: 'Records',
      label: 'Total page views'
    }, {
      id: 'page_load_time',
      field: 'transaction.duration.us',
      label: 'Page load time'
    }, {
      id: 'backend_time',
      field: 'transaction.marks.agent.timeToFirstByte',
      label: 'Backend time'
    }, {
      id: 'frontend_time',
      field: 'transaction.marks.agent.timeToFirstByte',
      label: 'Frontend time'
    }],
    labels: _constants.FieldLabels
  };
}