"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRumDistributionConfig = getRumDistributionConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRumDistributionConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.DISTRIBUTION,
    defaultSeriesType: 'line',
    seriesTypes: [],
    xAxisColumn: {
      sourceField: _constants.REPORT_METRIC_FIELD
    },
    yAxisColumns: [{
      sourceField: _constants.RECORDS_PERCENTAGE_FIELD,
      label: _labels.PAGES_LOADED_LABEL
    }],
    hasOperationType: false,
    filterFields: [{
      field: _elasticsearch_fieldnames.TRANSACTION_URL,
      isNegated: false
    }, _elasticsearch_fieldnames.USER_AGENT_OS, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, {
      field: _elasticsearch_fieldnames.USER_AGENT_NAME,
      nested: _elasticsearch_fieldnames.USER_AGENT_VERSION
    }, _constants.LABEL_FIELDS_FILTER],
    breakdownFields: [_elasticsearch_fieldnames.USER_AGENT_NAME, _elasticsearch_fieldnames.USER_AGENT_OS, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, _elasticsearch_fieldnames.SERVICE_NAME],
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT],
    metricOptions: [{
      label: _labels.PAGE_LOAD_TIME_LABEL,
      id: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      showPercentileAnnotations: true
    }, {
      label: _labels.BACKEND_TIME_LABEL,
      id: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE,
      field: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE
    }, {
      label: _labels.FCP_LABEL,
      id: _elasticsearch_fieldnames.FCP_FIELD,
      field: _elasticsearch_fieldnames.FCP_FIELD
    }, {
      label: _labels.TBT_LABEL,
      id: _elasticsearch_fieldnames.TBT_FIELD,
      field: _elasticsearch_fieldnames.TBT_FIELD
    }, {
      label: _labels.LCP_LABEL,
      id: _elasticsearch_fieldnames.LCP_FIELD,
      field: _elasticsearch_fieldnames.LCP_FIELD
    }, {
      label: _labels.INP_LABEL,
      id: _elasticsearch_fieldnames.INP_FIELD,
      field: _elasticsearch_fieldnames.INP_FIELD
    }, {
      label: _labels.CLS_LABEL,
      id: _elasticsearch_fieldnames.CLS_FIELD,
      field: _elasticsearch_fieldnames.CLS_FIELD
    }],
    baseFilters: [...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.TRANSACTION_TYPE, 'page-load', dataView), ...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.PROCESSOR_EVENT, 'transaction', dataView)],
    labels: {
      ..._constants.FieldLabels,
      [_elasticsearch_fieldnames.SERVICE_NAME]: _labels.WEB_APPLICATION_LABEL,
      [_elasticsearch_fieldnames.TRANSACTION_DURATION]: _labels.PAGE_LOAD_TIME_LABEL
    },
    // rum page load transactions are always less then 60 seconds
    query: {
      query: 'transaction.duration.us < 60000000',
      language: 'kuery'
    }
  };
}