"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlPlugin = void 0;
var _esqlTypes = require("@kbn/esql-types");
var _public = require("@kbn/kibana-utils-plugin/public");
var _esqlEditor = require("@kbn/esql-editor");
var _indexEditor = require("@kbn/index-editor");
var _esql_control_trigger = require("./triggers/esql_controls/esql_control_trigger");
var _update_esql_query_trigger = require("./triggers/update_esql_query/update_esql_query_trigger");
var _constants = require("./triggers/constants");
var _kibana_services = require("./kibana_services");
var _cache = require("./util/cache");
var _variables_service = require("./variables_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class EsqlPlugin {
  setup(core, {
    uiActions
  }) {
    uiActions.registerTrigger(_update_esql_query_trigger.updateESQLQueryTrigger);
    uiActions.registerTrigger(_esql_control_trigger.esqlControlTrigger);
    (0, _esqlEditor.registerESQLEditorAnalyticsEvents)(core.analytics);
    (0, _indexEditor.registerIndexEditorAnalyticsEvents)(core.analytics);
    return {};
  }
  start(core, {
    dataViews,
    expressions,
    data,
    uiActions,
    fieldsMetadata,
    usageCollection,
    licensing,
    fileUpload,
    fieldFormats,
    share
  }) {
    const storage = new _public.Storage(localStorage);

    // Register triggers
    uiActions.addTriggerActionAsync(_update_esql_query_trigger.UPDATE_ESQL_QUERY_TRIGGER, _constants.ACTION_UPDATE_ESQL_QUERY, async () => {
      const {
        UpdateESQLQueryAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./triggers/update_esql_query/update_esql_query_actions')));
      const appendESQLAction = new UpdateESQLQueryAction(data);
      return appendESQLAction;
    });
    uiActions.addTriggerActionAsync(_esql_control_trigger.ESQL_CONTROL_TRIGGER, _constants.ACTION_CREATE_ESQL_CONTROL, async () => {
      const {
        CreateESQLControlAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./triggers/esql_controls/esql_control_action')));
      const createESQLControlAction = new CreateESQLControlAction(core, data.search.search, data.query.timefilter.timefilter);
      return createESQLControlAction;
    });

    /** Async register the index editor UI actions */
    (0, _indexEditor.registerIndexEditorActions)({
      data,
      coreStart: core,
      share,
      uiActions,
      fieldFormats,
      fileUpload
    });
    const variablesService = new _variables_service.EsqlVariablesService();
    const getJoinIndicesAutocomplete = (0, _cache.cacheParametrizedAsyncFunction)(async remoteClusters => {
      const query = remoteClusters ? {
        remoteClusters
      } : {};
      const result = await core.http.get('/internal/esql/autocomplete/join/indices', {
        query
      });
      return result;
    }, remoteClusters => remoteClusters || '', 1000 * 60 * 5,
    // Keep the value in cache for 5 minutes
    1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
    );
    const getTimeseriesIndicesAutocomplete = (0, _cache.cacheNonParametrizedAsyncFunction)(async () => {
      const result = await core.http.get('/internal/esql/autocomplete/timeseries/indices');
      return result;
    }, 1000 * 60 * 5,
    // Keep the value in cache for 5 minutes
    1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
    );
    const getEditorExtensionsAutocomplete = async (queryString, activeSolutionId) => {
      const encodedQuery = encodeURIComponent(queryString);
      const result = await core.http.get(`${_esqlTypes.REGISTRY_EXTENSIONS_ROUTE}${activeSolutionId}/${encodedQuery}`);
      return result;
    };

    // Create a cached version of getEditorExtensionsAutocomplete
    const cachedGetEditorExtensionsAutocomplete = (0, _cache.cacheParametrizedAsyncFunction)(getEditorExtensionsAutocomplete, (queryString, activeSolutionId) => `${queryString}-${activeSolutionId}`, 1000 * 60 * 5,
    // Keep the value in cache for 5 minutes
    1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
    );
    const getInferenceEndpointsAutocomplete = (0, _cache.cacheParametrizedAsyncFunction)(async taskType => {
      return await core.http.get(`/internal/esql/autocomplete/inference_endpoints/${taskType}`);
    }, taskType => taskType, 1000 * 60 * 5,
    // Keep the value in cache for 5 minutes
    1000 * 15 // Refresh the cache in the background only if 15 seconds passed since the last call
    );
    const start = {
      getJoinIndicesAutocomplete,
      getTimeseriesIndicesAutocomplete,
      getEditorExtensionsAutocomplete: cachedGetEditorExtensionsAutocomplete,
      getInferenceEndpointsAutocomplete,
      variablesService,
      getLicense: async () => await (licensing === null || licensing === void 0 ? void 0 : licensing.getLicense())
    };
    (0, _kibana_services.setKibanaServices)(start, core, dataViews, data, expressions, storage, uiActions, fieldsMetadata, usageCollection);
    return start;
  }
  stop() {}
}
exports.EsqlPlugin = EsqlPlugin;