"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-utils-plugin/public");
var _row_viewer_lazy = require("./row_viewer_lazy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/esql_datagrid/public/data_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortOrder = [];
const DEFAULT_INITIAL_ROW_HEIGHT = 5;
const DEFAULT_ROWS_PER_PAGE = 10;
const ROWS_PER_PAGE_OPTIONS = [10, 25];
const DataGrid = props => {
  var _props$initialRowHeig, _props$share2;
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const [activeColumns, setActiveColumns] = (0, _react.useState)((props.initialColumns || (props.isTableView ? props.columns : [])).map(c => c.name));
  const [rowHeight, setRowHeight] = (0, _react.useState)((_props$initialRowHeig = props.initialRowHeight) !== null && _props$initialRowHeig !== void 0 ? _props$initialRowHeig : DEFAULT_INITIAL_ROW_HEIGHT);
  const [rowsPerPage, setRowsPerPage] = (0, _react.useState)(DEFAULT_ROWS_PER_PAGE);
  const onSetColumns = (0, _react.useCallback)(columns => {
    setActiveColumns(columns);
  }, []);
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns, customColumnsMeta) => {
    var _props$flyoutType;
    return /*#__PURE__*/_react.default.createElement(_row_viewer_lazy.RowViewer, {
      dataView: props.dataView,
      notifications: props.core.notifications,
      hit: hit,
      hits: displayedRows,
      columns: displayedColumns,
      columnsMeta: customColumnsMeta,
      flyoutType: (_props$flyoutType = props.flyoutType) !== null && _props$flyoutType !== void 0 ? _props$flyoutType : 'push',
      onRemoveColumn: column => {
        setActiveColumns(activeColumns.filter(c => c !== column));
      },
      onAddColumn: column => {
        setActiveColumns([...activeColumns, column]);
      },
      onClose: () => setExpandedDoc(undefined),
      setExpandedDoc: setExpandedDoc,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    });
  }, [activeColumns, props.core.notifications, props.dataView, props.flyoutType]);
  const columnsMeta = (0, _react.useMemo)(() => {
    return props.columns.reduce((acc, column) => {
      var _column$meta, _column$meta$esType, _column$meta2, _column$meta3;
      acc[column.id] = {
        type: (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.type,
        esType: (_column$meta$esType = (_column$meta2 = column.meta) === null || _column$meta2 === void 0 ? void 0 : _column$meta2.esType) !== null && _column$meta$esType !== void 0 ? _column$meta$esType : (_column$meta3 = column.meta) === null || _column$meta3 === void 0 ? void 0 : _column$meta3.type
      };
      return acc;
    }, {});
  }, [props.columns]);
  const rows = (0, _react.useMemo)(() => {
    var _props$columns;
    const columnNames = (_props$columns = props.columns) === null || _props$columns === void 0 ? void 0 : _props$columns.map(({
      name
    }) => name);
    return props.rows.map(row => (0, _lodash.zipObject)(columnNames, row)).map((row, idx) => {
      return {
        id: String(idx),
        raw: row,
        flattened: row
      };
    });
  }, [props.columns, props.rows]);
  const services = (0, _react.useMemo)(() => {
    const storage = new _public.Storage(localStorage);
    return {
      data: props.data,
      theme: props.core.theme,
      uiSettings: props.core.uiSettings,
      toastNotifications: props.core.notifications.toasts,
      fieldFormats: props.fieldFormats,
      storage
    };
  }, [props.core.notifications.toasts, props.core.theme, props.core.uiSettings, props.data, props.fieldFormats]);
  const discoverLocator = (0, _react.useMemo)(() => {
    var _props$share;
    return (_props$share = props.share) === null || _props$share === void 0 ? void 0 : _props$share.url.locators.get('DISCOVER_APP_LOCATOR');
  }, [(_props$share2 = props.share) === null || _props$share2 === void 0 ? void 0 : _props$share2.url.locators]);
  const renderToolbar = (0, _react.useCallback)(customToolbarProps => {
    const discoverLink = discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl({
      dataViewSpec: props.dataView.toSpec(),
      timeRange: props.data.query.timefilter.timefilter.getTime(),
      query: props.query,
      columns: activeColumns
    });
    return (0, _unifiedDataTable.renderCustomToolbar)({
      ...customToolbarProps,
      toolbarProps: {
        ...customToolbarProps.toolbarProps,
        hasRoomForGridControls: true
      },
      gridProps: {
        inTableSearchControl: customToolbarProps.gridProps.inTableSearchControl,
        additionalControls: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: discoverLink,
          target: "_blank",
          color: "primary",
          css: (0, _react2.css)`
                display: flex;
                align-items: center;
              `,
          external: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "discoverApp",
          size: "s",
          color: "primary",
          css: (0, _react2.css)`
                  margin-right: 4px;
                `,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('esqlDataGrid.openInDiscoverLabel', {
          defaultMessage: 'Open in Discover'
        })))
      }
    });
  }, [activeColumns, discoverLocator, props.data.query.timefilter.timefilter, props.dataView, props.query]);
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, {
    columns: activeColumns,
    css: (0, _react2.css)`
        .unifiedDataTableToolbar {
          padding: 4px 0px;
        }
      `,
    rows: rows,
    columnsMeta: columnsMeta,
    services: services,
    enableInTableSearch: true,
    isPlainRecord: true,
    isSortEnabled: false,
    loadingState: _unifiedDataTable.DataLoadingState.loaded,
    dataView: props.dataView,
    sampleSizeState: rows.length,
    rowsPerPageState: rowsPerPage,
    rowsPerPageOptions: ROWS_PER_PAGE_OPTIONS,
    onSetColumns: onSetColumns,
    onUpdateRowsPerPage: setRowsPerPage,
    expandedDoc: expandedDoc,
    setExpandedDoc: setExpandedDoc,
    showTimeCol: true,
    enableComparisonMode: true,
    sort: sortOrder,
    ariaLabelledBy: "esqlDataGrid",
    maxDocFieldsDisplayed: 100,
    renderDocumentView: renderDocumentView,
    showFullScreenButton: false,
    configRowHeight: DEFAULT_INITIAL_ROW_HEIGHT,
    rowHeightState: rowHeight,
    onUpdateRowHeight: setRowHeight,
    controlColumnIds: props.controlColumnIds,
    renderCustomToolbar: discoverLocator ? renderToolbar : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = DataGrid;
module.exports = exports.default;