"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEntitiesUpdatesIndexTemplateConfig = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _generate_component_id = require("../helpers/generate_component_id");
var _constants_entities = require("../../../../common/constants_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_RETENTION_PERIOD = '1d';
const generateEntitiesUpdatesIndexTemplateConfig = definition => ({
  name: (0, _generate_component_id.generateUpdatesIndexTemplateId)(definition),
  _meta: {
    description: "Index template for indices managed by the Elastic Entity Model's entity discovery framework for the updates dataset",
    ecs_version: '8.0.0',
    managed: true,
    managed_by: 'security_context_core_analysis'
  },
  data_stream: {},
  // creates data stream
  ignore_missing_component_templates: getCustomLatestTemplateComponents(definition),
  composed_of: [_constants_entities.ECS_MAPPINGS_COMPONENT_TEMPLATE, _constants_entities.ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1, ...getCustomLatestTemplateComponents(definition)],
  index_patterns: [(0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_UPDATES,
    definitionId: definition.id
  })],
  priority: 200,
  template: {
    lifecycle: {
      data_retention: DATA_RETENTION_PERIOD
    },
    settings: {
      index: {
        codec: 'best_compression'
      }
    }
  }
});
exports.generateEntitiesUpdatesIndexTemplateConfig = generateEntitiesUpdatesIndexTemplateConfig;
function getCustomLatestTemplateComponents(definition) {
  return [`${definition.id}-updates@platform`, `${definition.id}-updates@custom`];
}