"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexPipelines = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../common/types/api");
var _constants = require("../../../../shared/constants");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _doc_links = require("../../../../shared/doc_links");
var _revert_connector_pipeline_api_logic = require("../../../api/pipelines/revert_connector_pipeline_api_logic");
var _indices = require("../../../utils/indices");
var _constants2 = require("../constants");
var _index_name_logic = require("../index_name_logic");
var _inference_errors = require("./inference_errors");
var _inference_history = require("./inference_history");
var _customize_pipeline_item = require("./ingest_pipelines/customize_pipeline_item");
var _ingest_pipelines_card = require("./ingest_pipelines/ingest_pipelines_card");
var _manage_custom_pipeline_actions = require("./ingest_pipelines/manage_custom_pipeline_actions");
var _add_inference_pipeline_flyout = require("./ml_inference/add_inference_pipeline_flyout");
var _ml_inference_pipeline_processors_card = require("./ml_inference_pipeline_processors_card");
var _pipelines_json_configurations = require("./pipelines_json_configurations");
var _pipelines_logic = require("./pipelines_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/pipelines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIndexPipelines = () => {
  const {
    showMissingPipelineCallout,
    showAddMlInferencePipelineModal,
    hasIndexIngestionPipeline,
    index,
    isDeleteModalOpen,
    pipelineName,
    defaultPipelineValues,
    showPipelineSettings
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    closeAddMlInferencePipelineModal,
    closeDeleteModal,
    fetchDefaultPipeline,
    setPipelineState
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    status: revertStatus
  } = (0, _kea.useValues)(_revert_connector_pipeline_api_logic.RevertConnectorPipelineApilogic);
  const {
    makeRequest: revertPipeline
  } = (0, _kea.useActions)(_revert_connector_pipeline_api_logic.RevertConnectorPipelineApilogic);
  const apiIndex = (0, _indices.isApiIndex)(index);
  const extractionDisabled = (0, _indices.getContentExtractionDisabled)(index);
  const [isRevertPipeline, setRevertPipeline] = (0, _react.useState)(false);
  const buttonRef = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (!isDeleteModalOpen) {
      if (isRevertPipeline) {
        const pipelinesButton = document.querySelector(`[id="${_constants2.SearchIndexTabId.PIPELINES}"]`);
        if (pipelinesButton) {
          pipelinesButton.focus();
        }
        setRevertPipeline(false);
      } else if (buttonRef.current) {
        buttonRef.current.focus();
      }
    }
  }, [isDeleteModalOpen]);
  const onDeletePipeline = (0, _react.useCallback)(() => {
    revertPipeline({
      indexName
    });
    setRevertPipeline(true);
  }, [indexName, revertPipeline]);
  (0, _react.useEffect)(() => {
    if (index && !showPipelineSettings) {
      var _index$connector$pipe, _index$connector;
      fetchDefaultPipeline(undefined);
      setPipelineState((0, _indices.isConnectorIndex)(index) ? (_index$connector$pipe = (_index$connector = index.connector) === null || _index$connector === void 0 ? void 0 : _index$connector.pipeline) !== null && _index$connector$pipe !== void 0 ? _index$connector$pipe : defaultPipelineValues : defaultPipelineValues);
    }
  }, [index, showPipelineSettings]);
  if (!index) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const pipelinesTabs = [{
    content: /*#__PURE__*/_react.default.createElement(_inference_history.InferenceHistory, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 16
      }
    }),
    id: 'inference-history',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory', {
      defaultMessage: 'Inference history'
    })
  }, {
    content: /*#__PURE__*/_react.default.createElement(_pipelines_json_configurations.PipelinesJSONConfigurations, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 16
      }
    }),
    id: 'json-configurations',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations', {
      defaultMessage: 'JSON configurations'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showMissingPipelineCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.title', {
      defaultMessage: 'Custom pipeline missing'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.description', {
    defaultMessage: 'The custom pipeline for this index has been deleted. This may affect connector data ingestion. Its configuration will need to be reverted to the default pipeline settings.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    onClick: () => revertPipeline({
      indexName
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.missingPipeline.buttonLabel', {
    defaultMessage: 'Revert pipeline to default'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_customize_pipeline_item.CopyAndCustomizePipelinePanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.ingestPipelines,
      target: "_blank",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.docLink', {
      defaultMessage: 'Learn more about using pipelines in Search'
    })),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.title', {
      defaultMessage: 'Ingest Pipelines'
    })),
    subtitle: apiIndex ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.apiIndexSubtitle', {
      defaultMessage: "Ingest pipelines optimize your index for search applications. If you'd like to use these pipelines in your API-based index, you'll need to reference them explicitly in your API requests."
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.subtitle', {
      defaultMessage: 'Ingest pipelines optimize your index for search applications'
    }),
    iconType: "logstashInput",
    action: hasIndexIngestionPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "accent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.customBadge', {
      defaultMessage: 'Custom'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_manage_custom_pipeline_actions.ManageCustomPipelineActions, {
      buttonRef: buttonRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 21
      }
    }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.defaultBadge', {
      defaultMessage: 'Default'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ingest_pipelines_card.IngestPipelinesCard, {
    extractionDisabled: extractionDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.deployTrainedModels,
      target: "_blank",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.docLink', {
      defaultMessage: 'Learn more about deploying Machine Learning models in Elastic'
    })),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.title', {
      defaultMessage: 'Machine Learning Inference Pipelines'
    })),
    subtitle: apiIndex && hasIndexIngestionPipeline ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.subtitleAPIindex', {
      defaultMessage: "Inference pipelines will be run as processors from the Search Ingest Pipeline. In order to use these pipelines on API-based indices you'll need to reference the {pipelineName} pipeline in your API requests.",
      values: {
        pipelineName
      }
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.mlInferencePipelines.subtitle', {
      defaultMessage: 'Inference pipelines will be run as processors from the Search Ingest Pipeline'
    }),
    iconType: "compute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_inference_pipeline_processors_card.MlInferencePipelineProcessorsCard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: pipelinesTabs,
    initialSelectedTab: pipelinesTabs[0],
    autoFocus: "selected",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_inference_errors.InferenceErrors, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  }), showAddMlInferencePipelineModal && /*#__PURE__*/_react.default.createElement(_add_inference_pipeline_flyout.AddInferencePipelineFlyout, {
    onClose: closeAddMlInferencePipelineModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  }), isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.title', {
      defaultMessage: 'Delete custom pipeline'
    }),
    titleProps: {
      id: modalTitleId
    },
    isLoading: revertStatus === _api.Status.LOADING,
    onCancel: closeDeleteModal,
    onConfirm: onDeletePipeline,
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.confirmButton', {
      defaultMessage: 'Delete pipeline'
    }),
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.deleteModal.description', {
    defaultMessage: 'This will delete any custom pipelines associated with this index, including machine learning inference pipelines. The index will revert to using the default ingest pipeline.'
  }))));
};
exports.SearchIndexPipelines = SearchIndexPipelines;