"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _searchConnectors = require("@kbn/search-connectors");
var _doc_links = require("../../../../../shared/doc_links");
var _inline_editable_table = require("../../../../../shared/tables/inline_editable_table/inline_editable_table");
var _inline_editable_table_logic = require("../../../../../shared/tables/inline_editable_table/inline_editable_table_logic");
var _index_view_logic = require("../../index_view_logic");
var _translations = require("../../translations");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/connector/sync_rules/editable_basic_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const instanceId = 'FilteringRulesTable';
function validateItem(filteringRule) {
  if (filteringRule.rule === 'regex') {
    try {
      new RegExp(filteringRule.value);
      return {};
    } catch {
      return {
        value: _translations.REGEX_ERROR
      };
    }
  }
  return {};
}
const SyncRulesTable = () => {
  const {
    editableFilteringRules
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    addFilteringRule,
    deleteFilteringRule,
    reorderFilteringRules,
    updateFilteringRule
  } = (0, _kea.useActions)(_connector_filtering_logic.ConnectorFilteringLogic);
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, (0, _translations.getSyncRulesDescription)(indexName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, _translations.SYNC_RULES_LEARN_MORE_LINK));
  const columns = [{
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      autoFocus: true,
      fullWidth: true,
      value: filteringRule.policy,
      onChange: e => onChange(e.target.value),
      options: [{
        text: (0, _searchConnectors.filteringPolicyToText)('include'),
        value: 'include'
      }, {
        text: (0, _searchConnectors.filteringPolicyToText)('exclude'),
        value: 'exclude'
      }],
      "aria-label": _translations.BASIC_TABLE_POLICY_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }),
    field: 'policy',
    name: _translations.BASIC_TABLE_POLICY_TITLE,
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, (0, _searchConnectors.filteringPolicyToText)(indexingRule.policy))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.field,
      onChange: e => onChange(e.target.value),
      "aria-label": _translations.BASIC_TABLE_FIELD_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }))),
    field: 'field',
    name: _translations.BASIC_TABLE_FIELD_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }, rule.field))
  }, {
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: filteringRule.rule,
      onChange: e => onChange(e.target.value),
      options: Object.values(_searchConnectors.FilteringRuleRuleValues).map(rule => ({
        text: (0, _searchConnectors.filteringRuleToText)(rule),
        value: rule
      })),
      "aria-label": _translations.BASIC_TABLE_RULE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }),
    field: 'rule',
    name: _translations.BASIC_TABLE_RULE_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 25
      }
    }, (0, _searchConnectors.filteringRuleToText)(rule.rule))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.value,
      onChange: e => onChange(e.target.value),
      "aria-label": _translations.BASIC_TABLE_VALUE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }))),
    field: 'value',
    name: _translations.BASIC_TABLE_VALUE_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, rule.value))
  }];
  return /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    addButtonText: _translations.SYNC_RULES_TABLE_ADD_RULE_LABEL,
    ariaLabel: _translations.SYNC_RULES_TABLE_ARIA_LABEL,
    columns: columns,
    defaultItem: {
      policy: 'include',
      rule: 'equals',
      value: ''
    },
    description: description,
    instanceId: instanceId,
    items: editableFilteringRules,
    onAdd: rule => {
      const now = new Date().toISOString();
      const newRule = {
        ...rule,
        created_at: now,
        // crypto.randomUUID isn't widely enough available in browsers yet
        id: (0, _uuid.v4)(),
        updated_at: now
      };
      addFilteringRule(newRule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onDelete: deleteFilteringRule,
    onUpdate: rule => {
      updateFilteringRule(rule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onReorder: reorderFilteringRules,
    title: "",
    validateItem: validateItem,
    bottomRows: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 20
      }
    }, _translations.INCLUDE_EVERYTHING_ELSE_MESSAGE)],
    canRemoveLastItem: true,
    emptyPropertyAllowed: true,
    showRowIndex: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  });
};
exports.SyncRulesTable = SyncRulesTable;