"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var Constants = _interopRequireWildcard(require("../../../../shared/constants"));
var _validate_index_name = require("../../../utils/validate_index_name");
var _generated_config_fields = require("../../connector_detail/components/generated_config_fields");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _new_connector_logic = require("../../new_index/method_connector/new_connector_logic");
var _choose_connector = require("./components/choose_connector");
var _manual_configuration = require("./components/manual_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connectors/create_connector/start_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartStep = ({
  title,
  selfManagePreference,
  setCurrentStep,
  error
}) => {
  const isMediumDevice = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm', 'l']);
  const {
    rawName,
    canConfigureConnector,
    selectedConnector,
    generatedConfigData,
    isGenerateLoading,
    isCreateLoading
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setRawName,
    createConnector,
    generateConnectorName,
    setFormDirty
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const {
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const handleNameChange = e => {
    setRawName(e.target.value);
  };
  const formError = (0, _validate_index_name.isValidIndexName)(rawName) ? error : _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.nameInputHelpText.lineOne', {
    defaultMessage: '{connectorName} is an invalid index name',
    values: {
      connectorName: rawName
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: "enterprise-search-create-connector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isMediumDevice ? 'column' : 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_choose_connector.ChooseConnector, {
    selfManaged: selfManagePreference,
    disabled: !!connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: !!error,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.connectorNameLabel', {
      defaultMessage: 'Connector name'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      grow: false,
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 23
      }
    }, formError), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.startStep.namesShouldBeLowercaseTextLabel', {
      defaultMessage: 'The connector name should be lowercase and cannot contain spaces or special characters.'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!error,
    "data-test-subj": "enterpriseSearchStartStepFieldText",
    fullWidth: true,
    name: "connectorName",
    value: rawName,
    onChange: handleNameChange,
    disabled: !!connector,
    onBlur: () => {
      if (selectedConnector) {
        generateConnectorName({
          connectorName: rawName,
          connectorType: selectedConnector.serviceType,
          isManagedConnector: selectedConnector.isNative
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.euiFormRow.descriptionLabelAppend', {
      defaultMessage: 'Optional'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: !!connector,
    "data-test-subj": "enterpriseSearchStartStepFieldText",
    fullWidth: true,
    name: "connectorDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  }))))), selfManagePreference === 'selfManaged' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'plain' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.h4.deploymentLabel', {
    defaultMessage: 'Deployment'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) ? 'default' : 'subdued',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.p.youWillStartTheLabel', {
    defaultMessage: "We'll automatically configure your index, API key, and connector ID. Alternatively, create these manually and use a custom configuration."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchStartStepNextButton",
    onClick: () => {
      if (selectedConnector && selectedConnector.name) {
        createConnector({
          isSelfManaged: true
        });
        setFormDirty(true);
        setCurrentStep('deployment');
      }
    },
    fill: true,
    disabled: !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    isLoading: isCreateLoading || isGenerateLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }, Constants.NEXT_BUTTON_LABEL))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'plain' : 'subdued',
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.h4.configureIndexAndAPILabel', {
    defaultMessage: 'Configure index and API key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.name && (0, _validate_index_name.isValidIndexName)(rawName) && !error ? 'default' : 'subdued',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.p.thisProcessWillCreateLabel', {
    defaultMessage: 'This process will create a new index, API key, and a Connector ID. Optionally you can bring your own configuration as well.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 15
    }
  }), generatedConfigData && connector ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_generated_config_fields.GeneratedConfigFields, {
    apiKey: {
      api_key: generatedConfigData.apiKey.api_key,
      encoded: generatedConfigData.apiKey.encoded,
      id: generatedConfigData.apiKey.id,
      name: generatedConfigData.apiKey.name
    },
    connector: connector,
    isGenerateLoading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchStartStepGenerateConfigurationButton",
    fill: true,
    onClick: () => {
      setCurrentStep('configure');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 19
    }
  }, Constants.NEXT_BUTTON_LABEL)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-generateConfigButton",
    "data-telemetry-id": "entSearchContent-connector-configuration-generateConfigButton",
    disabled: !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    fill: true,
    iconType: "sparkles",
    isLoading: isGenerateLoading || isCreateLoading,
    onClick: () => {
      setFormDirty(true);
      createConnector({
        isSelfManaged: false
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.generateApiKey.button.label', {
    defaultMessage: 'Generate configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_manual_configuration.ManualConfiguration, {
    isDisabled: isGenerateLoading || isCreateLoading || !canConfigureConnector || !(0, _validate_index_name.isValidIndexName)(rawName) || Boolean(error),
    selfManagePreference: selfManagePreference,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 21
    }
  })))))));
};
exports.StartStep = StartStep;