"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMlInferenceErrors = exports.FetchMlInferenceErrorsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMlInferenceErrors = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/ml_inference/errors`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchMlInferenceErrors = fetchMlInferenceErrors;
const FetchMlInferenceErrorsApiLogic = exports.FetchMlInferenceErrorsApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_ml_inference_errors_api_logic'], fetchMlInferenceErrors);