"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationApiIntegrationStage = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _lzString = require("lz-string");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _doc_links = require("../../../../shared/doc_links");
var _kibana = require("../../../../shared/kibana");
var _search_application_view_logic = require("../search_application_view_logic");
var _search_application_api = require("./search_application_api");
var _search_application_api_logic = require("./search_application_api_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/connect/search_application_api_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const clientSnippet = (esUrl, searchApplicationName, apiKey) => `
import Client from '@elastic/search-application-client'
// or through CDN
// const Client = window['SearchApplicationClient']

const request = Client(
  ${searchApplicationName},
  ${esUrl},
  ${apiKey || '<YOUR_API_KEY>'},
)

const results = await request()
  .query('pizza')
  .addParameter('myCustomParameter', 'example value')
  .search()
`;
const cURLSnippet = (esUrl, searchApplicationName, apiKey, params) => `
curl --location --request POST '${esUrl}/_application/search_application/${searchApplicationName}/_search' \\
--header 'Authorization: apiKey ${apiKey || '<YOUR_API_KEY>'}' \\
--header 'Content-Type: application/json' \\
--data-raw '${JSON.stringify({
  params
}, null, 2)}'`;
const consoleSnippet = (searchApplicationName, params) => {
  const body = JSON.stringify({
    params
  }, null, 2);
  return `
POST /_application/search_application/${searchApplicationName}/_search
${body}
`;
};
const consoleRequest = (searchApplicationName, params) => `POST /_application/search_application/${searchApplicationName}/_search
${JSON.stringify({
  params
}, null, 2)}`;
const SearchApplicationApiIntegrationStage = () => {
  var _application$capabili, _application$capabili2, _share$url$locators$g;
  const {
    application,
    share
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [selectedTab, setSelectedTab] = _react.default.useState('apirequest');
  const {
    searchApplicationName
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    apiKey
  } = (0, _kea.useValues)(_search_application_api_logic.SearchApplicationApiLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const params = {
    query: 'pizza',
    myCustomParameter: 'example value'
  };
  const Tabs = {
    apirequest: {
      code: consoleSnippet(searchApplicationName, params),
      copy: false,
      language: 'http',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.tab.consoleTitle', {
        defaultMessage: 'Console'
      })
    },
    client: {
      code: clientSnippet((0, _search_application_api.elasticsearchUrl)(cloudContext), searchApplicationName, apiKey),
      copy: true,
      language: 'javascript',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.tab.clientTitle', {
        defaultMessage: 'Javascript Client'
      })
    },
    curl: {
      code: cURLSnippet((0, _search_application_api.elasticsearchUrl)(cloudContext), searchApplicationName, apiKey, params),
      copy: true,
      language: 'bash',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.tab.curlTitle', {
        defaultMessage: 'cURL'
      })
    }
  };
  const canShowDevtools = !!(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.dev_tools) !== null && _application$capabili2 !== void 0 && _application$capabili2.show);
  const consolePreviewLink = canShowDevtools ? share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({
    loadFrom: `data:text/plain,${(0, _lzString.compressToEncodedURIComponent)(consoleRequest(searchApplicationName, params))}`
  }, undefined, []) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.description",
    defaultMessage: "Simplify your API calls. We recommend using the JavaScript client.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, Object.entries(Tabs).map(([tabId, tab]) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tabId,
    isSelected: selectedTab === tabId,
    onClick: () => setSelectedTab(tabId),
    "data-telemetry-id": `entSearchApplications-searchApi-integration-tab-${tabId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, tab.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), selectedTab === 'client' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.installationTitle', {
    defaultMessage: 'Installation'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "inherit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.npmInstallDescription', {
    defaultMessage: 'Search application client is accessible from NPM package registry'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    lang: "bash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, `npm install @elastic/search-application-client`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "inherit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.cdnInstallDescription', {
    defaultMessage: 'or via CDN'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    lang: "html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, `<script src="https://cdn.jsdelivr.net/npm/@elastic/search-application-client@latest"></script>`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "inherit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.clientUsageTitle', {
    defaultMessage: 'Usage'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.clientUsageDescription",
    defaultMessage: "To get the most out of the JavaScript client, use the client's example template and follow our {searchapplicationSearchDocLink} on building a search experience.",
    values: {
      searchapplicationSearchDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.searchApplicationsSearch,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step3.clientDocumenation', {
        defaultMessage: 'how to guide'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: Tabs[selectedTab].copy,
    language: Tabs[selectedTab].language,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, Tabs[selectedTab].code), selectedTab === 'apirequest' && consolePreviewLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: consolePreviewLink,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchApi.step4.consoleButton",
    defaultMessage: "Try in console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  })))));
};
exports.SearchApplicationApiIntegrationStage = SearchApplicationApiIntegrationStage;