"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indicesCreateRequests = void 0;
var _nyc_taxisEnvironmentEvaluations = require("./nyc_taxis-[environment].evaluations.[date]");
var _postgresLogsEnvironmentEvaluations = require("./postgres-logs-[environment].evaluations.[date]");
var _employeesEnvironmentEvaluations = require("./employees-[environment].evaluations.[date]");
var _metricbeatEnvironment = require("./metricbeat-[environment].evaluations-[date]");
var _packetbeatEnvironmentEvaluations = require("./packetbeat-[environment].evaluations.[date]");
var _logsEnvironmentEvaluations = require("./logs-[environment].evaluations.[date]");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indicesCreateRequests = exports.indicesCreateRequests = {
  nycTaxisIndexCreateRequest: _nyc_taxisEnvironmentEvaluations.nycTaxisIndexCreateRequest,
  postgresLogsIndexCreateRequest: _postgresLogsEnvironmentEvaluations.postgresLogsIndexCreateRequest,
  employeesIndexCreateRequest: _employeesEnvironmentEvaluations.employeesIndexCreateRequest,
  metricbeatIndexCreateRequest: _metricbeatEnvironment.metricbeatIndexCreateRequest,
  packetbeatIndexCreateRequest: _packetbeatEnvironmentEvaluations.packetbeatIndexCreateRequest,
  logsIndexCreateRequest: _logsEnvironmentEvaluations.logsIndexCreateRequest
};