"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChainWithFormatInstructions = void 0;
var _prompts = require("@langchain/core/prompts");
var _output_parsers = require("@langchain/core/output_parsers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChainWithFormatInstructions = ({
  llm,
  generationSchema
}) => {
  const outputParser = _output_parsers.StructuredOutputParser.fromZodSchema(generationSchema);
  const formatInstructions = outputParser.getFormatInstructions();
  const prompt = _prompts.ChatPromptTemplate.fromTemplate(`Answer the user's question as best you can:\n{format_instructions}\n{query}`);
  const chain = prompt.pipe(llm);
  const llmType = llm._llmType();
  return {
    chain,
    formatInstructions,
    llmType
  };
};
exports.getChainWithFormatInstructions = getChainWithFormatInstructions;