"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetAppMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/observability_root_profile/accessors/get_app_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createGetAppMenu = services => prev => params => {
  const prevValue = prev(params);
  return {
    appMenuRegistry: registry => {
      // Register custom link actions
      registerDatasetQualityLink(registry, services);
      // Register alerts sub menu actions
      registerCreateSLOAction(registry, services, params);
      registerCustomThresholdRuleAction(registry, services, params);
      return prevValue.appMenuRegistry(registry);
    }
  };
};
exports.createGetAppMenu = createGetAppMenu;
const registerDatasetQualityLink = (registry, {
  share,
  timefilter
}) => {
  const dataQualityLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.DATA_QUALITY_LOCATOR_ID);
  if (dataQualityLocator) {
    registry.registerCustomAction({
      id: 'dataset-quality-link',
      type: _discoverUtils.AppMenuActionType.custom,
      controlProps: {
        label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.datasets', {
          defaultMessage: 'Data sets'
        }),
        testId: 'discoverAppMenuDatasetQualityLink',
        onClick: ({
          onFinishAction
        }) => {
          const refresh = timefilter.getRefreshInterval();
          const {
            from,
            to
          } = timefilter.getTime();
          dataQualityLocator.navigate({
            filters: {
              timeRange: {
                from: from !== null && from !== void 0 ? from : 'now-24h',
                to: to !== null && to !== void 0 ? to : 'now',
                refresh
              }
            }
          });
          onFinishAction();
        }
      }
    });
  }
};
const registerCustomThresholdRuleAction = (registry, {
  data,
  triggersActionsUi: {
    ruleTypeRegistry,
    actionTypeRegistry
  },
  ...services
}, {
  dataView,
  authorizedRuleTypeIds
}) => {
  if (!authorizedRuleTypeIds.includes(_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID)) return;
  registry.registerCustomActionUnderSubmenu(_discoverUtils.AppMenuActionId.alerts, {
    id: 'custom-threshold-rule',
    type: _discoverUtils.AppMenuActionType.custom,
    order: 101,
    controlProps: {
      label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.customThresholdRule', {
        defaultMessage: 'Create custom threshold rule'
      }),
      iconType: 'bell',
      testId: 'discoverAppMenuCustomThresholdRule',
      onClick: ({
        onFinishAction
      }) => {
        const index = dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec();
        const {
          filters,
          query
        } = data.query.getState();

        // Some of the rule form's required plugins are from x-pack, so make sure they're defined before
        // rendering the flyout. The alerting plugin is also part of x-pack, so this check should probably never
        // return false. This is mostly here because Typescript requires us to mark x-pack plugins as optional.
        const plugins = {
          ...services,
          data
        };
        if (!(0, _lib.isValidRuleFormPlugins)(plugins)) return null;
        return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
          plugins: {
            ...plugins,
            ruleTypeRegistry,
            actionTypeRegistry
          },
          consumer: _ruleDataUtils.AlertConsumers.ALERTS,
          validConsumers: [_ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.AlertConsumers.STACK_ALERTS, _ruleDataUtils.AlertConsumers.ALERTS],
          multiConsumerSelection: _ruleDataUtils.AlertConsumers.ALERTS,
          ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
          initialValues: {
            params: {
              searchConfiguration: {
                index,
                query,
                filter: filters
              }
            }
          },
          onSubmit: onFinishAction,
          onCancel: onFinishAction,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 11
          }
        });
      }
    }
  });
};
const registerCreateSLOAction = (registry, {
  data,
  discoverShared,
  application
}, {
  dataView,
  isEsqlMode
}) => {
  var _application$capabili;
  const sloFeature = discoverShared.features.registry.getById('observability-create-slo');
  const hasSloPermission = (_application$capabili = application.capabilities.slo) === null || _application$capabili === void 0 ? void 0 : _application$capabili.write;
  if (sloFeature && hasSloPermission) {
    registry.registerCustomActionUnderSubmenu(_discoverUtils.AppMenuActionId.alerts, {
      id: 'create-slo',
      type: _discoverUtils.AppMenuActionType.custom,
      order: 102,
      controlProps: {
        label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.slo', {
          defaultMessage: 'Create SLO'
        }),
        iconType: 'visGauge',
        testId: 'discoverAppMenuCreateSlo',
        onClick: ({
          onFinishAction
        }) => {
          const index = dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
          const timestampField = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName;
          const {
            filters,
            query: kqlQuery
          } = data.query.getState();
          const filter = isEsqlMode ? {} : {
            kqlQuery: (0, _esQuery.isOfQueryType)(kqlQuery) ? kqlQuery.query : '',
            filters: filters === null || filters === void 0 ? void 0 : filters.map(({
              meta,
              query
            }) => ({
              meta,
              query
            }))
          };
          return sloFeature.createSLOFlyout({
            initialValues: {
              indicator: {
                type: 'sli.kql.custom',
                params: {
                  index,
                  timestampField,
                  filter
                }
              }
            },
            onClose: onFinishAction
          });
        }
      }
    });
  }
};