"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatisticsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _esQuery = require("@kbn/es-query");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/field_stats_table/field_stats_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statsTableCss = (0, _react2.css)({
  width: '100%',
  height: '100%',
  overflowY: 'auto'
});
const fallBacklastReloadRequestTime$ = new _rxjs.BehaviorSubject(0);
const fallbackTotalHits = (0, _rxjs.of)(undefined);
const FieldStatisticsTable = exports.FieldStatisticsTable = /*#__PURE__*/_react.default.memo(props => {
  const {
    isEsqlMode,
    dataView,
    savedSearch,
    query,
    columns,
    filters,
    stateContainer,
    onAddFilter,
    trackUiMetric,
    searchSessionId,
    timeRange
  } = props;

  // If `_source` is in the columns, we should exclude it for Field Statistics
  const visibleFieldNames = (0, _react.useMemo)(() => columns.filter(col => col !== '_source'), [columns]);
  const renderFieldName = (0, _react.useCallback)((_, item) => {
    var _item$displayName;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_item$displayName = item.displayName) !== null && _item$displayName !== void 0 ? _item$displayName : item.fieldName);
  }, []);
  const services = (0, _use_discover_services.useDiscoverServices)();

  // Other apps consuming Discover UI might inject their own proxied data services
  // so we need override the kibana context services with the injected proxied services
  // to make sure the table use the right service
  const overridableServices = (0, _react.useMemo)(() => {
    return {
      data: services.data
    };
  }, [services.data]);
  const dataVisualizerService = services.dataVisualizer;

  // State from Discover we want the embeddable to reflect
  const showPreviewByDefault = (0, _react.useMemo)(() => stateContainer ? !stateContainer.appState.getState().hideAggregatedPreview : true, [stateContainer]);
  const lastReloadRequestTime$ = (0, _react.useMemo)(() => {
    var _stateContainer$dataS, _stateContainer$dataS2;
    return stateContainer !== null && stateContainer !== void 0 && (_stateContainer$dataS = stateContainer.dataState) !== null && _stateContainer$dataS !== void 0 && _stateContainer$dataS.refetch$ ? stateContainer === null || stateContainer === void 0 ? void 0 : (_stateContainer$dataS2 = stateContainer.dataState) === null || _stateContainer$dataS2 === void 0 ? void 0 : _stateContainer$dataS2.refetch$.pipe((0, _rxjs.map)(() => {
      return Date.now();
    })) : fallBacklastReloadRequestTime$;
  }, [stateContainer]);
  const totalHitsComplete$ = (0, _react.useMemo)(() => {
    return stateContainer ? stateContainer.dataState.data$.totalHits$.pipe((0, _rxjs.filter)(d => d.fetchStatus === 'complete'), (0, _rxjs.map)(d => d === null || d === void 0 ? void 0 : d.result)) : fallbackTotalHits;
  }, [stateContainer]);
  const totalDocuments = (0, _useObservable.default)(totalHitsComplete$);
  const lastReloadRequestTime = (0, _useObservable.default)(lastReloadRequestTime$);
  (0, _react.useEffect)(() => {
    // Track should only be called once when component is loaded
    trackUiMetric === null || trackUiMetric === void 0 ? void 0 : trackUiMetric(_analytics.METRIC_TYPE.LOADED, _constants.FIELD_STATISTICS_LOADED);
  }, [trackUiMetric]);
  const samplingOption = (0, _react.useMemo)(() => ({
    mode: 'normal_sampling',
    shardSize: 5000,
    seed: searchSessionId
  }), [searchSessionId]);
  const updateState = (0, _react.useCallback)(changes => {
    if (changes.showDistributions !== undefined && stateContainer) {
      stateContainer.appState.update({
        hideAggregatedPreview: !changes.showDistributions
      }, true);
    }
  }, [stateContainer]);
  if (!dataVisualizerService) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: statsTableCss,
    "data-test-subj": "dscFieldStatsEmbeddedContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(dataVisualizerService.FieldStatisticsTable, {
    shouldGetSubfields: true,
    dataView: dataView,
    savedSearch: savedSearch,
    filters: filters,
    esqlQuery: isEsqlMode && (0, _esQuery.isOfAggregateQueryType)(query) ? query : undefined,
    query: query,
    visibleFieldNames: visibleFieldNames,
    sessionId: searchSessionId,
    totalDocuments: totalDocuments,
    samplingOption: samplingOption,
    lastReloadRequestTime: lastReloadRequestTime,
    onAddFilter: onAddFilter,
    showPreviewByDefault: showPreviewByDefault,
    onTableUpdate: updateState,
    renderFieldName: renderFieldName,
    isEsqlMode: isEsqlMode,
    overridableServices: overridableServices,
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
});