"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsErrorsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _error_stacktrace_link = require("./error_stacktrace_link");
var _error_message = require("./error_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/failed_docs/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const contentColumnName = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.contentLabel', {
  defaultMessage: 'Content'
});
const typeColumnName = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.typeLabel', {
  defaultMessage: 'Type'
});
const typeColumnTooltip = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.typeTooltip', {
  defaultMessage: 'Error message category'
});
const getFailedDocsErrorsColumns = () => [{
  name: contentColumnName,
  field: 'message',
  render: (_, {
    message
  }) => {
    return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
      errorMessage: message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 14
      }
    });
  },
  mobileOptions: {
    width: '100%'
  }
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: typeColumnTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, `${typeColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }))),
  field: 'type',
  render: (_, {
    type
  }) => {
    return /*#__PURE__*/_react.default.createElement(_error_stacktrace_link.ErrorStacktraceLink, {
      errorType: type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 14
      }
    });
  },
  sortable: true
}];
exports.getFailedDocsErrorsColumns = getFailedDocsErrorsColumns;