"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClonePanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasSerializableState)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationContainers.apiCanDuplicatePanels)(api.parentApi));
class ClonePanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_CLONE_PANEL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_CLONE_PANEL);
    (0, _defineProperty2.default)(this, "order", 45);
    (0, _defineProperty2.default)(this, "grouping", [_constants.DASHBOARD_ACTION_GROUP]);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardClonePanelActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'copy';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$blockingE;
    if (!isApiCompatible(embeddable)) return false;
    return Boolean(!((_embeddable$blockingE = embeddable.blockingError$) !== null && _embeddable$blockingE !== void 0 && _embeddable$blockingE.value) && (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit');
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    embeddable.parentApi.duplicatePanel(embeddable.uuid);
  }
}
exports.ClonePanelAction = ClonePanelAction;