"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CapabilitiesService = void 0;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/**
 * Service that is responsible for UI Capabilities.
 * @internal
 */
class CapabilitiesService {
  async start({
    appIds,
    http
  }) {
    const useDefaultCapabilities = http.anonymousPaths.isAnonymous(window.location.pathname);
    const capabilities = await http.post('/api/core/capabilities', {
      query: useDefaultCapabilities ? {
        useDefaultCapabilities
      } : undefined,
      body: JSON.stringify({
        applications: appIds
      })
    });
    return {
      capabilities: (0, _std.deepFreeze)(capabilities)
    };
  }
}
exports.CapabilitiesService = CapabilitiesService;