"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lightenColor = lightenColor;
var _coloring = require("@kbn/coloring");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_LIGHTNESS = 0.93;
const MAX_LIGHTNESS_SPACE = 0.2;
function lightenColor(baseColor, step, totalSteps) {
  if (totalSteps === 1) {
    return baseColor;
  }
  const [h, s, l] = (0, _coloring.getValidColor)(baseColor, {
    shouldBeCompatibleWithColorJs: true
  }).hsl();
  const lightnessSpace = Math.min(MAX_LIGHTNESS - l, MAX_LIGHTNESS_SPACE);
  const currentLevelTargetLightness = l + lightnessSpace * ((step - 1) / (totalSteps - 1));
  return _chromaJs.default.hsl(h, s, currentLevelTargetLightness).hex();
}