"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilesTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _file_name_link = require("./file_name_link");
var _file_actions_popover_button = require("./file_actions_popover_button");
var _file_icon = require("./file_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/use_files_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useFilesTableColumns = ({
  caseId,
  showPreview
}) => {
  return [{
    name: i18n.NAME,
    field: 'name',
    'data-test-subj': 'cases-files-table-filename',
    render: (name, file) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_file_icon.FileIcon, {
      file: file,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_file_name_link.FileNameLink, {
      file: file,
      showPreview: () => showPreview(file),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    })),
    width: '60%'
  }, {
    name: i18n.TYPE,
    'data-test-subj': 'cases-files-table-filetype',
    render: attachment => {
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 16
        }
      }, (0, _utils.parseMimeType)(attachment.mimeType));
    }
  }, {
    name: i18n.DATE_ADDED,
    field: 'created',
    'data-test-subj': 'cases-files-table-date-added',
    dataType: 'date'
  }, {
    name: i18n.ACTIONS,
    width: '120px',
    actions: [{
      name: i18n.ACTIONS,
      render: theFile => /*#__PURE__*/_react.default.createElement(_file_actions_popover_button.FileActionsPopoverButton, {
        caseId: caseId,
        theFile: theFile,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 13
        }
      })
    }]
  }];
};
exports.useFilesTableColumns = useFilesTableColumns;