"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrEmptyTagFromValue = exports.getOrEmptyTag = exports.getEmptyValue = exports.getEmptyStringTag = exports.getEmptyString = exports.getEmptyCellValue = exports.defaultToEmptyTag = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/empty_value/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyWrapperCss = ({
  euiTheme
}) => ({
  color: euiTheme.colors.mediumShade
});
const getEmptyValue = () => '—';
exports.getEmptyValue = getEmptyValue;
const getEmptyString = () => `(${i18n.EMPTY_STRING})`;
exports.getEmptyString = getEmptyString;
const getEmptyCellValue = () => /*#__PURE__*/_react.default.createElement("span", {
  css: emptyWrapperCss,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 40
  }
}, getEmptyValue());
exports.getEmptyCellValue = getEmptyCellValue;
const getEmptyStringTag = () => /*#__PURE__*/_react.default.createElement("span", {
  css: emptyWrapperCss,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 40
  }
}, getEmptyString());
exports.getEmptyStringTag = getEmptyStringTag;
const defaultToEmptyTag = item => {
  if (item == null) {
    return getEmptyCellValue();
  } else if ((0, _fp.isString)(item) && item === '') {
    return getEmptyStringTag();
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item);
  }
};
exports.defaultToEmptyTag = defaultToEmptyTag;
const getOrEmptyTag = (path, item) => {
  const text = (0, _fp.get)(path, item);
  return getOrEmptyTagFromValue(text);
};
exports.getOrEmptyTag = getOrEmptyTag;
const getOrEmptyTagFromValue = value => {
  if (value == null) {
    return getEmptyCellValue();
  } else if (value === '') {
    return getEmptyStringTag();
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
  }
};
exports.getOrEmptyTagFromValue = getOrEmptyTagFromValue;