"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTagsSelectable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_items_state = require("../use_items_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/actions/tags/edit_tags_selectable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasExactMatch = (searchValue, options) => {
  return options.some(option => option.key === searchValue);
};
const hasPartialMatch = (searchValue, options) => {
  return options.some(option => {
    var _option$key;
    return (_option$key = option.key) === null || _option$key === void 0 ? void 0 : _option$key.includes(searchValue);
  });
};
const itemToSelectableOption = item => {
  return {
    key: item.key,
    label: item.key,
    'data-test-subj': `cases-actions-tags-edit-selectable-tag-${item.key}`
  };
};
const EditTagsSelectableComponent = ({
  selectedCases,
  tags,
  isLoading,
  onChangeTags
}) => {
  const {
    state,
    options,
    totalSelectedItems,
    onChange,
    onSelectAll,
    onSelectNone
  } = (0, _use_items_state.useItemsState)({
    items: tags,
    selectedCases,
    itemToSelectableOption,
    fieldSelector: theCase => theCase.tags,
    onChangeItems: onChangeTags
  });
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const renderOption = (0, _react.useCallback)((option, search) => {
    const dataTestSubj = option.newItem ? 'cases-actions-tags-edit-selectable-add-new-tag-icon' : `cases-actions-tags-edit-selectable-tag-${option.label}-icon-${option.itemIcon}`;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: option.itemIcon,
      "data-test-subj": dataTestSubj,
      css: {
        flexShrink: 0,
        marginRight: euiTheme.size.m
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: search,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, option.label));
  }, [euiTheme]);

  /**
   * While the user searches we need to add the ability
   * to add the search term as a new tag. The no matches message
   * is not enough because a search term can partial match to some tags
   * but the user will still need to add the search term as tag.
   * For that reason, we always add a "fake" option ("add new tag" option) which will serve as a
   * the button with which the user can add a new tag. We do not show
   * the "add new tag" option if there is an exact match.
   */
  const optionsWithAddNewTagOption = (0, _react.useMemo)(() => {
    if (!(0, _lodash.isEmpty)(searchValue) && !hasExactMatch(searchValue, options)) {
      return [{
        key: searchValue,
        label: i18n.ADD_TAG_CUSTOM_OPTION_LABEL(searchValue),
        'data-test-subj': 'cases-actions-tags-edit-selectable-add-new-tag',
        data: {
          itemIcon: 'empty',
          newItem: true
        }
      }, ...options];
    }
    return options;
  }, [options, searchValue]);
  const showNoMatchText = (0, _react.useMemo)(() => !hasPartialMatch(searchValue, options) && Object.keys(state.items).length > 0, [options, searchValue, state.items]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: optionsWithAddNewTagOption,
    searchable: true,
    searchProps: {
      placeholder: i18n.SEARCH_PLACEHOLDER,
      isLoading,
      isClearable: !isLoading,
      onChange: setSearchValue,
      value: searchValue,
      'data-test-subj': 'cases-actions-tags-edit-selectable-search-input'
    },
    renderOption: renderOption,
    listProps: {
      showIcons: false
    },
    onChange: onChange,
    noMatchesMessage: i18n.NO_SEARCH_MATCH,
    emptyMessage: i18n.NO_TAGS_AVAILABLE,
    "data-test-subj": "cases-actions-tags-edit-selectable",
    height: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    direction: "row",
    css: {
      flexGrow: 0
    },
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      borderRight: euiTheme.border.thin,
      paddingRight: euiTheme.size.s
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, i18n.TOTAL_TAGS(tags.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingLeft: euiTheme.size.s
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, i18n.SELECTED_TAGS(totalSelectedItems))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: onSelectAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 19
    }
  }, i18n.SELECT_ALL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: onSelectNone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 19
    }
  }, i18n.SELECT_NONE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), showNoMatchText ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    textAlign: "center",
    css: {
      marginBottom: euiTheme.size.s
    },
    "data-test-subj": "cases-actions-tags-edit-selectable-no-match-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, i18n.NO_SEARCH_MATCH) : null, list));
};
EditTagsSelectableComponent.displayName = 'EditTagsSelectable';
const EditTagsSelectable = exports.EditTagsSelectable = /*#__PURE__*/_react.default.memo(EditTagsSelectableComponent);