"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _popover = require("../../popover");
var _constants = require("../../../../common/lib/constants");
var _flatten_panel_tree = require("../../../lib/flatten_panel_tree");
var _auto_refresh_controls = require("./auto_refresh_controls");
var _kiosk_controls = require("./kiosk_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/view_menu/view_menu.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getAutoplaySettingsMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.autoplaySettingsMenuItemLabel', {
    defaultMessage: 'Autoplay settings'
  }),
  getFullscreenMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.fullscreenMenuLabel', {
    defaultMessage: 'Enter fullscreen mode'
  }),
  getHideEditModeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.hideEditModeLabel', {
    defaultMessage: 'Hide editing controls'
  }),
  getRefreshMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.refreshMenuItemLabel', {
    defaultMessage: 'Refresh data'
  }),
  getRefreshSettingsMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.refreshSettingsMenuItemLabel', {
    defaultMessage: 'Auto refresh settings'
  }),
  getShowEditModeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.showEditModeLabel', {
    defaultMessage: 'Show editing controls'
  }),
  getViewMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.viewMenuButtonLabel', {
    defaultMessage: 'View'
  }),
  getViewMenuLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.viewMenuLabel', {
    defaultMessage: 'View options'
  }),
  getZoomFitToWindowText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomFitToWindowText', {
    defaultMessage: 'Fit to window'
  }),
  getZoomInText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomInText', {
    defaultMessage: 'Zoom in'
  }),
  getZoomMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomMenuItemLabel', {
    defaultMessage: 'Zoom'
  }),
  getZoomOutText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomOutText', {
    defaultMessage: 'Zoom out'
  }),
  getZoomPercentage: scale => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomResetText', {
    defaultMessage: '{scalePercentage}%',
    values: {
      scalePercentage: scale * 100
    }
  }),
  getZoomResetText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderViewMenu.zoomPrecentageValue', {
    defaultMessage: 'Reset'
  })
};
const QUICK_ZOOM_LEVELS = [0.5, 1, 2];
const ViewMenu = ({
  enterFullscreen,
  fitToWindow,
  isWriteable,
  resetZoom,
  setZoomScale,
  toggleWriteable,
  zoomIn,
  zoomOut,
  zoomScale,
  doRefresh,
  refreshInterval,
  setRefreshInterval,
  autoplayEnabled,
  autoplayInterval,
  setAutoplayInterval
}) => {
  const setRefresh = val => setRefreshInterval(val);
  const disableInterval = () => {
    setRefresh(0);
  };
  const viewControl = togglePopover => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "aria-label": strings.getViewMenuLabel(),
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, strings.getViewMenuButtonLabel());
  const getScaleMenuItems = () => QUICK_ZOOM_LEVELS.map(scale => ({
    name: strings.getZoomPercentage(scale),
    icon: 'empty',
    onClick: () => setZoomScale(scale)
  }));
  const getZoomMenuItems = () => [{
    name: strings.getZoomFitToWindowText(),
    icon: 'empty',
    onClick: fitToWindow,
    disabled: zoomScale === _constants.MAX_ZOOM_LEVEL
  }, ...getScaleMenuItems(), {
    name: strings.getZoomInText(),
    icon: 'magnifyWithPlus',
    onClick: zoomIn,
    disabled: zoomScale === _constants.MAX_ZOOM_LEVEL,
    className: 'canvasContextMenu--topBorder'
  }, {
    name: strings.getZoomOutText(),
    icon: 'magnifyWithMinus',
    onClick: zoomOut,
    disabled: zoomScale <= _constants.MIN_ZOOM_LEVEL
  }, {
    name: strings.getZoomResetText(),
    icon: 'empty',
    onClick: resetZoom,
    disabled: zoomScale >= _constants.MAX_ZOOM_LEVEL,
    className: 'canvasContextMenu--topBorder'
  }];
  const getPanelTree = closePopover => ({
    id: 0,
    items: [{
      name: strings.getRefreshMenuItemLabel(),
      icon: 'refresh',
      onClick: () => {
        doRefresh();
      }
    }, {
      name: strings.getRefreshSettingsMenuItemLabel(),
      icon: 'empty',
      panel: {
        id: 1,
        title: strings.getRefreshSettingsMenuItemLabel(),
        content: /*#__PURE__*/_react.default.createElement(_auto_refresh_controls.AutoRefreshControls, {
          refreshInterval: refreshInterval,
          setRefresh: val => setRefresh(val),
          disableInterval: () => disableInterval(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 236,
            columnNumber: 13
          }
        })
      }
    }, {
      name: strings.getFullscreenMenuItemLabel(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "fullScreen",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 15
        }
      }),
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      onClick: () => {
        enterFullscreen();
        closePopover();
      }
    }, {
      name: strings.getAutoplaySettingsMenuItemLabel(),
      icon: 'empty',
      panel: {
        id: 2,
        title: strings.getAutoplaySettingsMenuItemLabel(),
        content: /*#__PURE__*/_react.default.createElement(_kiosk_controls.KioskControls, {
          autoplayInterval: autoplayInterval,
          onSetInterval: setAutoplayInterval,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 260,
            columnNumber: 13
          }
        })
      }
    }, {
      name: isWriteable ? strings.getHideEditModeLabel() : strings.getShowEditModeLabel(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: isWriteable ? 'eyeClosed' : 'eye',
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 269,
          columnNumber: 15
        }
      }),
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      onClick: () => {
        toggleWriteable();
        closePopover();
      }
    }, {
      name: strings.getZoomMenuItemLabel(),
      icon: 'magnifyWithPlus',
      panel: {
        id: 3,
        title: strings.getZoomMenuItemLabel(),
        items: getZoomMenuItems()
      }
    }]
  });
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    button: viewControl,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 5
    }
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: (0, _flatten_panel_tree.flattenPanelTree)(getPanelTree(closePopover)),
    className: "canvasViewMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  }));
};
exports.ViewMenu = ViewMenu;
ViewMenu.propTypes = {
  isWriteable: _propTypes.default.bool.isRequired,
  zoomScale: _propTypes.default.number.isRequired,
  fitToWindow: _propTypes.default.func.isRequired,
  setZoomScale: _propTypes.default.func.isRequired,
  zoomIn: _propTypes.default.func.isRequired,
  zoomOut: _propTypes.default.func.isRequired,
  resetZoom: _propTypes.default.func.isRequired,
  toggleWriteable: _propTypes.default.func.isRequired,
  enterFullscreen: _propTypes.default.func.isRequired,
  doRefresh: _propTypes.default.func.isRequired,
  refreshInterval: _propTypes.default.number.isRequired,
  setRefreshInterval: _propTypes.default.func.isRequired,
  autoplayEnabled: _propTypes.default.bool.isRequired,
  autoplayInterval: _propTypes.default.number.isRequired,
  setAutoplayInterval: _propTypes.default.func.isRequired
};