"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconFromType = exports.FieldsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ecs = require("@elastic/ecs");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/review_step/fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getIconFromType = type => {
  switch (type) {
    case 'string':
      return 'tokenString';
    case 'keyword':
      return 'tokenKeyword';
    case 'number':
    case 'long':
      return 'tokenNumber';
    case 'date':
      return 'tokenDate';
    case 'ip':
    case 'geo_point':
      return 'tokenGeo';
    case 'object':
      return 'tokenQuestion';
    case 'float':
      return 'tokenNumber';
    default:
      return 'tokenQuestion';
  }
};
exports.getIconFromType = getIconFromType;
const tooltipAnchorProps = {
  css: {
    display: 'flex'
  }
};
const columns = [{
  field: 'name',
  name: 'Name',
  sortable: true,
  render: (name, {
    type
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, type ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: type,
      anchorProps: tooltipAnchorProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      "data-test-subj": `field-${name}-icon`,
      iconType: getIconFromType(type !== null && type !== void 0 ? type : null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 17
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, name));
  }
}, {
  field: 'value',
  name: 'Value',
  sortable: true
}];
const search = {
  box: {
    incremental: true,
    schema: true
  }
};
const flattenDocument = document => {
  if (!document) {
    return [];
  }
  const fields = [];
  const flatten = (object, prefix = '') => {
    Object.entries(object).forEach(([key, value]) => {
      const name = `${prefix}${key}`;
      if (!Array.isArray(value) && typeof value === 'object' && value !== null) {
        flatten(value, `${name}.`);
      } else {
        var _EcsFlat$name;
        fields.push({
          name,
          value,
          type: (_EcsFlat$name = _ecs.EcsFlat[name]) === null || _EcsFlat$name === void 0 ? void 0 : _EcsFlat$name.type
        });
      }
    });
  };
  flatten(document);
  return fields;
};
const FieldsTable = exports.FieldsTable = /*#__PURE__*/_react.default.memo(({
  documents = []
}) => {
  const fields = (0, _react.useMemo)(() => flattenDocument(documents[0]), [documents]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: fields,
    columns: columns,
    search: search,
    pagination: true,
    sorting: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  });
});
FieldsTable.displayName = 'FieldsTable';