"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonsFooter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireDefault(require("react"));
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/common/components/buttons_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const bottomBarCss = (0, _react.css)`
  animation: none !important; // disable the animation to prevent the footer from flickering
`;
const containerCss = (0, _react.css)`
  min-height: 40px;
`;
const contentCss = (0, _react.css)`
  width: 100%;
  max-width: 730px;
`;
const ButtonsFooter = exports.ButtonsFooter = /*#__PURE__*/_react2.default.memo(({
  cancelButtonText,
  nextButtonText,
  backButtonText,
  onNext,
  onBack,
  hideCancel = false,
  isNextDisabled = false
}) => {
  const integrationsUrl = (0, _use_kibana.useKibana)().services.application.getUrlForApp('integrations');
  return /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "s",
    position: "sticky",
    css: bottomBarCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    css: containerCss,
    "data-test-subj": "buttonsFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: contentCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 15
    }
  }, !hideCancel && /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: integrationsUrl,
    color: "text",
    "data-test-subj": "buttonsFooter-cancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 19
    }
  }, cancelButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }, onBack && /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    onClick: onBack,
    color: "text",
    "data-test-subj": "buttonsFooter-backButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 23
    }
  }, backButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.back",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  }, onNext && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: onNext,
    isDisabled: isNextDisabled,
    "data-test-subj": "buttonsFooter-nextButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 23
    }
  }, nextButtonText || /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.footer.next",
    defaultMessage: "Next",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 27
    }
  })))))))));
});
ButtonsFooter.displayName = 'ButtonsFooter';