"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAgentCommands = getApmAgentCommands;
exports.getApmAgentHighlightLang = getApmAgentHighlightLang;
exports.getApmAgentLineNumbers = getApmAgentLineNumbers;
exports.getApmAgentVariables = getApmAgentVariables;
exports.secretTokenKeys = void 0;
var _mustache = _interopRequireDefault(require("mustache"));
var _java = require("./java");
var _node = require("./node");
var _django = require("./django");
var _flask = require("./flask");
var _rails = require("./rails");
var _rack = require("./rack");
var _go = require("./go");
var _dotnet = require("./dotnet");
var _php = require("./php");
var _rum = require("./rum");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmAgentCommandsMap = {
  java: _java.java,
  node: _node.node,
  django: _django.django,
  flask: _flask.flask,
  rails: _rails.rails,
  rack: _rack.rack,
  go: _go.go,
  dotnet: _dotnet.dotnet,
  php: _php.php,
  js: _rum.rum,
  js_script: _rum.rumScript
};
const apmAgentVariablesMap = {
  java: _java.javaVariables,
  node: _node.nodeVariables,
  django: _django.djangoVariables,
  flask: _flask.flaskVariables,
  rails: _rails.railsVariables,
  rack: _rack.rackVariables,
  go: _go.goVariables,
  dotnet: _dotnet.dotnetVariables,
  php: _php.phpVariables,
  js: _rum.rumVariables
};
const apmAgentLineNumbersMap = {
  java: _java.javaLineNumbers,
  node: _node.nodeLineNumbers,
  django: _django.djangoLineNumbers,
  flask: _flask.flaskLineNumbers,
  rails: _rails.railsLineNumbers,
  rack: _rack.rackLineNumbers,
  go: _go.goLineNumbers,
  dotnet: _dotnet.dotnetLineNumbers,
  php: _php.phpLineNumbers,
  js: _rum.rumLineNumbers
};
const apmAgentHighlightLangMap = {
  java: _java.javaHighlightLang,
  node: _node.nodeHighlightLang,
  django: _django.djangoHighlightLang,
  flask: _flask.flaskHighlightLang,
  rails: _rails.railsHighlightLang,
  rack: _rack.rackHighlightLang,
  go: _go.goHighlightLang,
  dotnet: _dotnet.dotnetHighlightLang,
  php: _php.phpHighlightLang,
  js: _rum.rumHighlightLang
};
function getApmAgentCommands({
  variantId,
  policyDetails,
  defaultValues
}) {
  const commands = apmAgentCommandsMap[variantId];
  if (!commands) {
    return '';
  }
  return _mustache.default.render(commands, {
    ...policyDetails,
    ...defaultValues
  });
}
function getApmAgentVariables(variantId) {
  return apmAgentVariablesMap[variantId];
}
function getApmAgentLineNumbers(variantId) {
  return apmAgentLineNumbersMap[variantId];
}
function getApmAgentHighlightLang(variantId) {
  return apmAgentHighlightLangMap[variantId];
}
const secretTokenKeys = exports.secretTokenKeys = [_django.djangoVariables.secretToken, _dotnet.dotnetVariables.secretToken, _flask.flaskVariables.secretToken, _go.goVariables.secretToken, _java.javaVariables.secretToken, _node.nodeVariables.secretToken, _php.phpVariables.secretToken, _rack.rackVariables.secretToken, _rails.railsVariables.secretToken];