"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteButton = DeleteButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _create_call_apm_api = require("../../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_edit_custom_link_flyout/delete_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DeleteButton({
  onDelete,
  customLinkId
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmDeleteButtonDeleteButton",
    color: "danger",
    isLoading: isDeleting,
    iconSide: "right",
    onClick: async () => {
      setIsDeleting(true);
      await deleteConfig(customLinkId, toasts);
      setIsDeleting(false);
      onDelete();
    },
    style: {
      marginRight: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.delete', {
    defaultMessage: 'Delete'
  }));
}
async function deleteConfig(customLinkId, toasts) {
  try {
    await (0, _create_call_apm_api.callApmApi)('DELETE /internal/apm/settings/custom_links/{id}', {
      signal: null,
      params: {
        path: {
          id: customLinkId
        }
      }
    });
    toasts.addSuccess({
      iconType: 'trash',
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.delete.successed', {
        defaultMessage: 'Deleted custom link.'
      })
    });
  } catch (error) {
    toasts.addDanger({
      iconType: 'cross',
      title: _i18n.i18n.translate('xpack.apm.settings.customLink.delete.failed', {
        defaultMessage: 'Custom link could not be deleted'
      })
    });
  }
}