"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeRuleRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _uuid = require("uuid");
var _validate_internal_rule_type = require("../../../../lib/validate_internal_rule_type");
var _snooze = require("../../../../../../common/routes/rule/apis/snooze");
var _lib = require("../../../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../../types");
var _constants = require("../../../../constants");
var _schedule = require("../../../../../../common/routes/schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snoozeRuleRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/snooze_schedule`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: 'Schedule a snooze for the rule',
      description: 'When you snooze a rule, the rule checks continue to run but alerts will not generate actions. You can snooze for a specified period of time and schedule single or recurring downtimes.',
      tags: ['oas-tag:alerting'],
      availability: {
        since: '8.19.0',
        stability: 'stable'
      }
    },
    validate: {
      request: {
        params: _snooze.snoozeParamsSchemaV1,
        body: _snooze.snoozeBodySchemaV1
      },
      response: {
        200: {
          body: () => _snooze.snoozeResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given id does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    var _req$body$schedule;
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const ruleTypes = alertingContext.listTypes();
    const params = req.params;
    const customSchedule = (_req$body$schedule = req.body.schedule) === null || _req$body$schedule === void 0 ? void 0 : _req$body$schedule.custom;
    if (!customSchedule) {
      throw _boom.default.badRequest('A schedule is required');
    }
    const {
      rRule,
      duration
    } = (0, _schedule.transformCustomScheduleToRRule)(customSchedule);
    const snoozeScheduleId = (0, _uuid.v4)();
    try {
      var _snoozedRule$snoozeSc;
      const rule = await rulesClient.get({
        id: params.id
      });
      (0, _validate_internal_rule_type.validateInternalRuleType)({
        ruleTypeId: rule.alertTypeId,
        ruleTypes,
        operationText: 'snooze'
      });
      const snoozedRule = await rulesClient.snooze({
        id: params.id,
        snoozeSchedule: {
          duration,
          rRule,
          id: snoozeScheduleId
        }
      });
      const createdSchedule = (_snoozedRule$snoozeSc = snoozedRule.snoozeSchedule) === null || _snoozedRule$snoozeSc === void 0 ? void 0 : _snoozedRule$snoozeSc.find(schedule => schedule.id === snoozeScheduleId);
      let transformedCustomSchedule;
      if (createdSchedule) {
        transformedCustomSchedule = (0, _schedule.transformRRuleToCustomSchedule)(createdSchedule);
      }
      const response = {
        body: {
          schedule: {
            id: snoozeScheduleId,
            ...(transformedCustomSchedule && {
              custom: {
                ...transformedCustomSchedule,
                duration: customSchedule.duration
              }
            })
          }
        }
      };
      return res.ok(response);
    } catch (e) {
      if (e instanceof _lib.RuleMutedError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.snoozeRuleRoute = snoozeRuleRoute;