"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEditRuleParamsOptionsSchema = exports.bulkEditRuleParamsOperationsSchema = exports.bulkEditRuleParamsOperationSchema = exports.bulkEditParamsOperationsSchema = exports.bulkEditParamsOperationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkEditExceptionListField = _configSchema.schema.literal('exceptionsList');
const bulkEditParamsOperationSchema = exports.bulkEditParamsOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.oneOf([bulkEditExceptionListField]),
  value: _configSchema.schema.any()
});
const bulkEditParamsOperationsSchema = exports.bulkEditParamsOperationsSchema = _configSchema.schema.arrayOf(bulkEditParamsOperationSchema, {
  minSize: 1
});
const bulkEditRuleParamsOptionsSchema = exports.bulkEditRuleParamsOptionsSchema = _configSchema.schema.object({
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  })),
  operations: bulkEditParamsOperationsSchema
});
const bulkEditExceptionListParamField = _configSchema.schema.literal('params.exceptionsList');
const bulkEditRuleParamsOperationSchema = exports.bulkEditRuleParamsOperationSchema = _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.oneOf([bulkEditExceptionListParamField]),
  value: _configSchema.schema.any()
});
const bulkEditRuleParamsOperationsSchema = exports.bulkEditRuleParamsOperationsSchema = _configSchema.schema.arrayOf(bulkEditRuleParamsOperationSchema, {
  minSize: 1
});