"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionAppState = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _constants = require("@kbn/aiops-common/constants");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
var _page_header = require("../page_header");
var _change_point_detection_page = require("./change_point_detection_page");
var _change_point_detection_context = require("./change_point_detection_context");
var _time_series_dataview_check = require("../../application/utils/time_series_dataview_check");
var _use_reload = require("../../hooks/use_reload");
var _use_filters_query = require("../../hooks/use_filters_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/change_point_detection_root.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the ChangePointDetectionAppState component.
 */

const ChangePointDetectionAppState = ({
  dataView,
  savedSearch,
  appContextValue,
  showFrozenDataTierChoice = true
}) => {
  var _appContextValue$case, _appContextValue$case2, _appContextValue$case3;
  const datePickerDeps = {
    ...(0, _lodash.pick)(appContextValue, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'change_point_detection');
  const reload$ = (0, _react.useMemo)(() => {
    return _mlDatePicker.mlTimefilterRefresh$.pipe((0, _rxjs.map)(v => v.lastRefresh));
  }, []);
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  appContextValue.embeddingOrigin = _constants.AIOPS_EMBEDDABLE_ORIGIN.ML_AIOPS_LABS;
  const CasesContext = (_appContextValue$case = (_appContextValue$case2 = appContextValue.cases) === null || _appContextValue$case2 === void 0 ? void 0 : _appContextValue$case2.ui.getCasesContext()) !== null && _appContextValue$case !== void 0 ? _appContextValue$case : _react.default.Fragment;
  const casesPermissions = (_appContextValue$case3 = appContextValue.cases) === null || _appContextValue$case3 === void 0 ? void 0 : _appContextValue$case3.helpers.canUseCases();
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: reload$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_page.ChangePointDetectionPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 25
    }
  })))))))))));
};
exports.ChangePointDetectionAppState = ChangePointDetectionAppState;