"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildPlanBindingConstraintsList = buildPlanBindingConstraintsList;
const SingleImmutableLinkedList_1 = require("../../common/models/SingleImmutableLinkedList");
function buildPlanBindingConstraintsList(params) {
    const tags = new Map();
    if (params.rootConstraints.tag !== undefined) {
        tags.set(params.rootConstraints.tag.key, params.rootConstraints.tag.value);
    }
    return new SingleImmutableLinkedList_1.SingleImmutableLinkedList({
        elem: {
            getAncestorsCalled: false,
            name: params.rootConstraints.name,
            serviceIdentifier: params.rootConstraints.serviceIdentifier,
            tags,
        },
        previous: undefined,
    });
}
//# sourceMappingURL=buildPlanBindingConstraintsList.js.map