"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsSelector = IntegrationsSelector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/filters/integrations_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const integrationsSelectorLabel = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorLabel', {
  defaultMessage: 'Integrations'
});
const integrationsSelectorLoading = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorLoading', {
  defaultMessage: 'Loading integrations'
});
const integrationsSelectorSearchPlaceholder = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorSearchPlaceholder', {
  defaultMessage: 'Filter integrations'
});
const integrationsSelectorNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorNoneAvailable', {
  defaultMessage: 'No integrations available'
});
const integrationsSelectorNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorNoneMatching', {
  defaultMessage: 'No integrations found'
});
function IntegrationsSelector({
  isLoading,
  integrations,
  onIntegrationsChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = integration => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
    integration: integration,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, integration.title));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "datasetQualityIntegrationsSelectableButton",
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: integrations.length,
    hasActiveFilters: !!integrations.find(item => item.checked === 'on'),
    numActiveFilters: integrations.filter(item => item.checked === 'on').length,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, integrationsSelectorLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "datasetQualityIntegrationsSelectable",
    searchable: true,
    searchProps: {
      placeholder: integrationsSelectorSearchPlaceholder,
      compressed: true
    },
    "aria-label": integrationsSelectorLabel,
    options: integrations,
    onChange: onIntegrationsChange,
    isLoading: isLoading,
    loadingMessage: integrationsSelectorLoading,
    emptyMessage: integrationsSelectorNoneAvailable,
    noMatchesMessage: integrationsSelectorNoneMatching,
    renderOption: option => renderOption(option),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, search), list)));
}